/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.CombineFnBase;
import com.google.cloud.dataflow.sdk.transforms.CombineWithContext;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.CombineContextFactory;
import com.google.cloud.dataflow.sdk.util.PerKeyCombineFnRunner;
import com.google.cloud.dataflow.sdk.util.SideInputReader;
import java.util.Collection;

public class PerKeyCombineFnRunners {
    public static <K, InputT, AccumT, OutputT> PerKeyCombineFnRunner<K, InputT, AccumT, OutputT> create(CombineFnBase.PerKeyCombineFn<K, InputT, AccumT, OutputT> perKeyCombineFn) {
        if (perKeyCombineFn instanceof CombineWithContext.RequiresContextInternal) {
            return new KeyedCombineFnWithContextRunner((CombineWithContext.KeyedCombineFnWithContext)perKeyCombineFn);
        }
        return new KeyedCombineFnRunner((Combine.KeyedCombineFn)perKeyCombineFn);
    }

    private static class KeyedCombineFnWithContextRunner<K, InputT, AccumT, OutputT>
    implements PerKeyCombineFnRunner<K, InputT, AccumT, OutputT> {
        private final CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> keyedCombineFnWithContext;

        private KeyedCombineFnWithContextRunner(CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> keyedCombineFnWithContext) {
            this.keyedCombineFnWithContext = keyedCombineFnWithContext;
        }

        @Override
        public CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> fn() {
            return this.keyedCombineFnWithContext;
        }

        @Override
        public AccumT createAccumulator(K key, DoFn.ProcessContext c) {
            return this.keyedCombineFnWithContext.createAccumulator(key, CombineContextFactory.createFromProcessContext(c));
        }

        @Override
        public AccumT addInput(K key, AccumT accumulator, InputT value, DoFn.ProcessContext c) {
            return this.keyedCombineFnWithContext.addInput(key, accumulator, value, CombineContextFactory.createFromProcessContext(c));
        }

        @Override
        public AccumT mergeAccumulators(K key, Iterable<AccumT> accumulators, DoFn.ProcessContext c) {
            return this.keyedCombineFnWithContext.mergeAccumulators(key, accumulators, CombineContextFactory.createFromProcessContext(c));
        }

        @Override
        public OutputT extractOutput(K key, AccumT accumulator, DoFn.ProcessContext c) {
            return this.keyedCombineFnWithContext.extractOutput(key, accumulator, CombineContextFactory.createFromProcessContext(c));
        }

        @Override
        public AccumT compact(K key, AccumT accumulator, DoFn.ProcessContext c) {
            return this.keyedCombineFnWithContext.compact(key, accumulator, CombineContextFactory.createFromProcessContext(c));
        }

        @Override
        public OutputT apply(K key, Iterable<? extends InputT> inputs, DoFn.ProcessContext c) {
            return this.keyedCombineFnWithContext.apply(key, inputs, CombineContextFactory.createFromProcessContext(c));
        }

        @Override
        public AccumT addInputs(K key, Iterable<InputT> inputs, DoFn.ProcessContext c) {
            CombineWithContext.Context combineContext = CombineContextFactory.createFromProcessContext(c);
            AccumT accum = this.keyedCombineFnWithContext.createAccumulator(key, combineContext);
            for (InputT input : inputs) {
                accum = this.keyedCombineFnWithContext.addInput(key, accum, input, combineContext);
            }
            return accum;
        }

        public String toString() {
            return this.keyedCombineFnWithContext.toString();
        }

        @Override
        public AccumT createAccumulator(K key, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.keyedCombineFnWithContext.createAccumulator(key, CombineContextFactory.createFromComponents(options, sideInputReader, Iterables.getOnlyElement(windows)));
        }

        @Override
        public AccumT addInput(K key, AccumT accumulator, InputT input, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.keyedCombineFnWithContext.addInput(key, accumulator, input, CombineContextFactory.createFromComponents(options, sideInputReader, Iterables.getOnlyElement(windows)));
        }

        @Override
        public AccumT mergeAccumulators(K key, Iterable<AccumT> accumulators, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.keyedCombineFnWithContext.mergeAccumulators(key, accumulators, CombineContextFactory.createFromComponents(options, sideInputReader, Iterables.getOnlyElement(windows)));
        }

        @Override
        public OutputT extractOutput(K key, AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.keyedCombineFnWithContext.extractOutput(key, accumulator, CombineContextFactory.createFromComponents(options, sideInputReader, Iterables.getOnlyElement(windows)));
        }

        @Override
        public AccumT compact(K key, AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.keyedCombineFnWithContext.compact(key, accumulator, CombineContextFactory.createFromComponents(options, sideInputReader, Iterables.getOnlyElement(windows)));
        }
    }

    private static class KeyedCombineFnRunner<K, InputT, AccumT, OutputT>
    implements PerKeyCombineFnRunner<K, InputT, AccumT, OutputT> {
        private final Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> keyedCombineFn;

        private KeyedCombineFnRunner(Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> keyedCombineFn) {
            this.keyedCombineFn = keyedCombineFn;
        }

        @Override
        public Combine.KeyedCombineFn<K, InputT, AccumT, OutputT> fn() {
            return this.keyedCombineFn;
        }

        @Override
        public AccumT createAccumulator(K key, DoFn.ProcessContext c) {
            return this.keyedCombineFn.createAccumulator(key);
        }

        @Override
        public AccumT addInput(K key, AccumT accumulator, InputT input, DoFn.ProcessContext c) {
            return this.keyedCombineFn.addInput(key, accumulator, input);
        }

        @Override
        public AccumT mergeAccumulators(K key, Iterable<AccumT> accumulators, DoFn.ProcessContext c) {
            return this.keyedCombineFn.mergeAccumulators(key, accumulators);
        }

        @Override
        public OutputT extractOutput(K key, AccumT accumulator, DoFn.ProcessContext c) {
            return this.keyedCombineFn.extractOutput(key, accumulator);
        }

        @Override
        public AccumT compact(K key, AccumT accumulator, DoFn.ProcessContext c) {
            return this.keyedCombineFn.compact(key, accumulator);
        }

        @Override
        public OutputT apply(K key, Iterable<? extends InputT> inputs, DoFn.ProcessContext c) {
            return this.keyedCombineFn.apply(key, inputs);
        }

        @Override
        public AccumT addInputs(K key, Iterable<InputT> inputs, DoFn.ProcessContext c) {
            AccumT accum = this.keyedCombineFn.createAccumulator(key);
            for (InputT input : inputs) {
                accum = this.keyedCombineFn.addInput(key, accum, input);
            }
            return accum;
        }

        public String toString() {
            return this.keyedCombineFn.toString();
        }

        @Override
        public AccumT createAccumulator(K key, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.keyedCombineFn.createAccumulator(key);
        }

        @Override
        public AccumT addInput(K key, AccumT accumulator, InputT input, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.keyedCombineFn.addInput(key, accumulator, input);
        }

        @Override
        public AccumT mergeAccumulators(K key, Iterable<AccumT> accumulators, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.keyedCombineFn.mergeAccumulators(key, accumulators);
        }

        @Override
        public OutputT extractOutput(K key, AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.keyedCombineFn.extractOutput(key, accumulator);
        }

        @Override
        public AccumT compact(K key, AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.keyedCombineFn.compact(key, accumulator);
        }
    }
}

