/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import java.util.Arrays;

public class MovingFunction {
    private final long sampleUpdateMs;
    private final int numSignificantBuckets;
    private final int numSignificantSamples;
    private final Combine.BinaryCombineLongFn function;
    private final long[] buckets;
    private final int[] numSamples;
    private long currentMsSinceEpoch;
    private int currentIndex;

    public MovingFunction(long samplePeriodMs, long sampleUpdateMs, int numSignificantBuckets, int numSignificantSamples, Combine.BinaryCombineLongFn function) {
        this.sampleUpdateMs = sampleUpdateMs;
        this.numSignificantBuckets = numSignificantBuckets;
        this.numSignificantSamples = numSignificantSamples;
        this.function = function;
        int n = (int)(samplePeriodMs / sampleUpdateMs);
        this.buckets = new long[n];
        Arrays.fill(this.buckets, function.identity());
        this.numSamples = new int[n];
        Arrays.fill(this.numSamples, 0);
        this.currentMsSinceEpoch = -1L;
        this.currentIndex = -1;
    }

    private void flush(long nowMsSinceEpoch) {
        Preconditions.checkArgument(nowMsSinceEpoch >= 0L, "Only positive timestamps supported");
        if (this.currentIndex < 0) {
            this.currentMsSinceEpoch = nowMsSinceEpoch - nowMsSinceEpoch % this.sampleUpdateMs;
            this.currentIndex = 0;
        }
        Preconditions.checkArgument(nowMsSinceEpoch >= this.currentMsSinceEpoch, "Attempting to move backwards");
        int newBuckets = Math.min((int)((nowMsSinceEpoch - this.currentMsSinceEpoch) / this.sampleUpdateMs), this.buckets.length);
        while (newBuckets > 0) {
            this.currentIndex = (this.currentIndex + 1) % this.buckets.length;
            this.buckets[this.currentIndex] = this.function.identity();
            this.numSamples[this.currentIndex] = 0;
            --newBuckets;
            this.currentMsSinceEpoch += this.sampleUpdateMs;
        }
    }

    public void add(long nowMsSinceEpoch, long value) {
        this.flush(nowMsSinceEpoch);
        this.buckets[this.currentIndex] = this.function.apply(this.buckets[this.currentIndex], value);
        int n = this.currentIndex;
        this.numSamples[n] = this.numSamples[n] + 1;
    }

    public long get(long nowMsSinceEpoch) {
        this.flush(nowMsSinceEpoch);
        long result = this.function.identity();
        for (int i = 0; i < this.buckets.length; ++i) {
            result = this.function.apply(result, this.buckets[i]);
        }
        return result;
    }

    public boolean isSignificant() {
        int totalSamples = 0;
        int activeBuckets = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            totalSamples += this.numSamples[i];
            if (this.numSamples[i] <= 0) continue;
            ++activeBuckets;
        }
        return activeBuckets >= this.numSignificantBuckets || totalSamples >= this.numSignificantSamples;
    }
}

