/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.NonMergingWindowFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import java.util.Collection;
import org.joda.time.Instant;

class IdentityWindowFn<T>
extends NonMergingWindowFn<T, BoundedWindow> {
    private final Coder<BoundedWindow> coder;
    private final boolean assignsToSingleWindow;

    public IdentityWindowFn(Coder<? extends BoundedWindow> coder, boolean assignsToSingleWindow) {
        Coder<? extends BoundedWindow> windowCoder = coder;
        this.coder = windowCoder;
        this.assignsToSingleWindow = assignsToSingleWindow;
    }

    @Override
    public Collection<BoundedWindow> assignWindows(WindowFn.AssignContext c) throws Exception {
        Collection<BoundedWindow> priorWindows = c.windows();
        return priorWindows;
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        throw new UnsupportedOperationException(String.format("%s.isCompatible() should never be called. It is a private implementation detail of sdk utilities. This message indicates a bug in the Beam SDK.", this.getClass().getCanonicalName()));
    }

    @Override
    public Coder<BoundedWindow> windowCoder() {
        return this.coder;
    }

    @Override
    public boolean assignsToSingleWindow() {
        return this.assignsToSingleWindow;
    }

    @Override
    public BoundedWindow getSideInputWindow(BoundedWindow window) {
        throw new UnsupportedOperationException(String.format("%s.getSideInputWindow() should never be called. It is a private implementation detail of sdk utilities. This message indicates a bug in the Beam SDK.", this.getClass().getCanonicalName()));
    }

    @Override
    @Deprecated
    public Instant getOutputTime(Instant inputTimestamp, BoundedWindow window) {
        return inputTimestamp;
    }
}

