/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Predicate;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Predicates;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.FluentIterable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.util.IOChannelFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIOChannelFactory
implements IOChannelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FileIOChannelFactory.class);

    @Override
    public Collection<String> match(String spec) throws IOException {
        File file = new File(spec);
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            throw new IOException("Unable to find parent directory of " + spec);
        }
        String pathToMatch = file.getAbsolutePath().replaceAll(Matcher.quoteReplacement("\\"), Matcher.quoteReplacement("\\\\"));
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pathToMatch);
        FluentIterable<File> files = com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.Files.fileTreeTraverser().preOrderTraversal(parent);
        Iterable<File> matchedFiles = Iterables.filter(files, Predicates.and(com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.Files.isFile(), new Predicate<File>(){

            @Override
            public boolean apply(File input) {
                return matcher.matches(input.toPath());
            }
        }));
        LinkedList<String> result = new LinkedList<String>();
        for (File match : matchedFiles) {
            result.add(match.getPath());
        }
        return result;
    }

    @Override
    public ReadableByteChannel open(String spec) throws IOException {
        LOG.debug("opening file {}", (Object)spec);
        FileInputStream inputStream = new FileInputStream(spec);
        return inputStream.getChannel();
    }

    @Override
    public WritableByteChannel create(String spec, String mimeType) throws IOException {
        LOG.debug("creating file {}", (Object)spec);
        File file = new File(spec);
        if (!(file.getAbsoluteFile().getParentFile() == null || file.getAbsoluteFile().getParentFile().exists() || file.getAbsoluteFile().getParentFile().mkdirs() || file.getAbsoluteFile().getParentFile().exists())) {
            throw new IOException("Unable to create parent directories for '" + spec + "'");
        }
        return Channels.newChannel(new BufferedOutputStream(new FileOutputStream(file)));
    }

    @Override
    public long getSizeBytes(String spec) throws IOException {
        try {
            return Files.size(FileSystems.getDefault().getPath(spec, new String[0]));
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getReason());
        }
    }

    @Override
    public boolean isReadSeekEfficient(String spec) throws IOException {
        return true;
    }

    @Override
    public String resolve(String path, String other) throws IOException {
        return Paths.get(path, new String[0]).resolve(other).toString();
    }
}

