/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExecutableTrigger<W extends BoundedWindow>
implements Serializable {
    private final int triggerIndex;
    private final int firstIndexAfterSubtree;
    private final List<ExecutableTrigger<W>> subTriggers = new ArrayList<ExecutableTrigger<W>>();
    private final Trigger<W> trigger;

    public static <W extends BoundedWindow> ExecutableTrigger<W> create(Trigger<W> trigger) {
        return ExecutableTrigger.create(trigger, 0);
    }

    private static <W extends BoundedWindow> ExecutableTrigger<W> create(Trigger<W> trigger, int nextUnusedIndex) {
        if (trigger instanceof Trigger.OnceTrigger) {
            return new ExecutableOnceTrigger((Trigger.OnceTrigger)trigger, nextUnusedIndex);
        }
        return new ExecutableTrigger<W>(trigger, nextUnusedIndex);
    }

    public static <W extends BoundedWindow> ExecutableTrigger<W> createForOnceTrigger(Trigger.OnceTrigger<W> trigger, int nextUnusedIndex) {
        return new ExecutableOnceTrigger<W>(trigger, nextUnusedIndex);
    }

    private ExecutableTrigger(Trigger<W> trigger, int nextUnusedIndex) {
        this.trigger = Preconditions.checkNotNull(trigger, "trigger must not be null");
        this.triggerIndex = nextUnusedIndex++;
        if (trigger.subTriggers() != null) {
            for (Trigger<W> subTrigger : trigger.subTriggers()) {
                ExecutableTrigger<W> subExecutable = ExecutableTrigger.create(subTrigger, nextUnusedIndex);
                this.subTriggers.add(subExecutable);
                nextUnusedIndex = subExecutable.firstIndexAfterSubtree;
            }
        }
        this.firstIndexAfterSubtree = nextUnusedIndex;
    }

    public List<ExecutableTrigger<W>> subTriggers() {
        return this.subTriggers;
    }

    public String toString() {
        return this.trigger.toString();
    }

    public Trigger<W> getSpec() {
        return this.trigger;
    }

    public int getTriggerIndex() {
        return this.triggerIndex;
    }

    public final int getFirstIndexAfterSubtree() {
        return this.firstIndexAfterSubtree;
    }

    public boolean isCompatible(ExecutableTrigger<W> other) {
        return this.trigger.isCompatible(other.trigger);
    }

    public ExecutableTrigger<W> getSubTriggerContaining(int index) {
        Preconditions.checkNotNull(this.subTriggers);
        Preconditions.checkState(index > this.triggerIndex && index < this.firstIndexAfterSubtree, "Cannot find sub-trigger containing index not in this tree.");
        ExecutableTrigger<W> previous = null;
        for (ExecutableTrigger<W> subTrigger : this.subTriggers) {
            if (index < subTrigger.triggerIndex) {
                return previous;
            }
            previous = subTrigger;
        }
        return previous;
    }

    public void invokeOnElement(Trigger.OnElementContext c) throws Exception {
        this.trigger.onElement((Trigger.OnElementContext)c.forTrigger(this));
    }

    public void invokeOnMerge(Trigger.OnMergeContext c) throws Exception {
        Trigger.TriggerContext subContext = c.forTrigger(this);
        this.trigger.onMerge((Trigger.OnMergeContext)subContext);
    }

    public boolean invokeShouldFire(Trigger.TriggerContext c) throws Exception {
        return this.trigger.shouldFire(c.forTrigger(this));
    }

    public void invokeOnFire(Trigger.TriggerContext c) throws Exception {
        this.trigger.onFire(c.forTrigger(this));
    }

    public void invokeClear(Trigger.TriggerContext c) throws Exception {
        this.trigger.clear(c.forTrigger(this));
    }

    private static class ExecutableOnceTrigger<W extends BoundedWindow>
    extends ExecutableTrigger<W> {
        public ExecutableOnceTrigger(Trigger.OnceTrigger<W> trigger, int nextUnusedIndex) {
            super(trigger, nextUnusedIndex);
        }
    }
}

