/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.util.VarInt;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BufferedElementCountingOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private final ByteBuffer buffer;
    private final OutputStream os;
    private boolean finished;
    private long count;

    public BufferedElementCountingOutputStream(OutputStream os) {
        this(os, 65536);
    }

    BufferedElementCountingOutputStream(OutputStream os, int bufferSize) {
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.os = os;
        this.finished = false;
        this.count = 0L;
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.flush();
        VarInt.encode(0, this.os);
        this.finished = true;
    }

    public void markElementStart() throws IOException {
        if (this.finished) {
            throw new IOException("Stream has been finished. Can not add any more elements.");
        }
        ++this.count;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has been finished. Can not write any more data.");
        }
        if (this.count == 0L) {
            this.os.write(b);
            return;
        }
        if (this.buffer.hasRemaining()) {
            this.buffer.put((byte)b);
        } else {
            this.outputBuffer();
            this.os.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has been finished. Can not write any more data.");
        }
        if (this.count == 0L) {
            this.os.write(b, off, len);
            return;
        }
        if (this.buffer.remaining() >= len) {
            this.buffer.put(b, off, len);
        } else {
            this.outputBuffer();
            this.os.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.finished) {
            return;
        }
        this.outputBuffer();
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.os.close();
    }

    private void outputBuffer() throws IOException {
        if (this.count > 0L) {
            VarInt.encode(this.count, this.os);
            this.os.write(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position());
            this.buffer.clear();
            this.count = 0L;
        }
    }
}

