/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseExecutionContext<T extends ExecutionContext.StepContext>
implements ExecutionContext {
    private Map<String, T> cachedStepContexts = new HashMap<String, T>();

    protected abstract T createStepContext(String var1, String var2, StateSampler var3);

    public T getOrCreateStepContext(String stepName, String transformName, StateSampler stateSampler) {
        ExecutionContext.StepContext context = (ExecutionContext.StepContext)this.cachedStepContexts.get(stepName);
        if (context == null) {
            context = this.createStepContext(stepName, transformName, stateSampler);
            this.cachedStepContexts.put(stepName, context);
        }
        return (T)context;
    }

    public Collection<? extends T> getAllStepContexts() {
        return Collections.unmodifiableCollection(this.cachedStepContexts.values());
    }

    @Override
    public void noteOutput(WindowedValue<?> output) {
    }

    @Override
    public void noteSideOutput(TupleTag<?> tag, WindowedValue<?> output) {
    }

    public static abstract class StepContext
    implements ExecutionContext.StepContext {
        private final ExecutionContext executionContext;
        private final String stepName;
        private final String transformName;

        public StepContext(ExecutionContext executionContext, String stepName, String transformName) {
            this.executionContext = executionContext;
            this.stepName = stepName;
            this.transformName = transformName;
        }

        @Override
        public String getStepName() {
            return this.stepName;
        }

        @Override
        public String getTransformName() {
            return this.transformName;
        }

        @Override
        public void noteOutput(WindowedValue<?> output) {
            this.executionContext.noteOutput(output);
        }

        @Override
        public void noteSideOutput(TupleTag<?> tag, WindowedValue<?> output) {
            this.executionContext.noteSideOutput(tag, output);
        }

        @Override
        public <T, W extends BoundedWindow> void writePCollectionViewData(TupleTag<?> tag, Iterable<WindowedValue<T>> data, Coder<Iterable<WindowedValue<T>>> dataCoder, W window, Coder<W> windowCoder) throws IOException {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public abstract StateInternals<?> stateInternals();

        @Override
        public abstract TimerInternals timerInternals();
    }
}

