/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.transforms.CombineFnBase;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import java.io.Serializable;

public class AppliedCombineFn<K, InputT, AccumT, OutputT>
implements Serializable {
    private final CombineFnBase.PerKeyCombineFn<K, InputT, AccumT, OutputT> fn;
    private final Coder<AccumT> accumulatorCoder;
    private final Iterable<PCollectionView<?>> sideInputViews;
    private final KvCoder<K, InputT> kvCoder;
    private final WindowingStrategy<?, ?> windowingStrategy;

    private AppliedCombineFn(CombineFnBase.PerKeyCombineFn<K, InputT, AccumT, OutputT> fn, Coder<AccumT> accumulatorCoder, Iterable<PCollectionView<?>> sideInputViews, KvCoder<K, InputT> kvCoder, WindowingStrategy<?, ?> windowingStrategy) {
        this.fn = fn;
        this.accumulatorCoder = accumulatorCoder;
        this.sideInputViews = sideInputViews;
        this.kvCoder = kvCoder;
        this.windowingStrategy = windowingStrategy;
    }

    public static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> withAccumulatorCoder(CombineFnBase.PerKeyCombineFn<? super K, ? super InputT, AccumT, OutputT> fn, Coder<AccumT> accumCoder) {
        return AppliedCombineFn.withAccumulatorCoder(fn, accumCoder, null, null, null);
    }

    public static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> withAccumulatorCoder(CombineFnBase.PerKeyCombineFn<? super K, ? super InputT, AccumT, OutputT> fn, Coder<AccumT> accumCoder, Iterable<PCollectionView<?>> sideInputViews, KvCoder<K, InputT> kvCoder, WindowingStrategy<?, ?> windowingStrategy) {
        CombineFnBase.PerKeyCombineFn<? super K, ? super InputT, AccumT, OutputT> clonedFn = SerializableUtils.clone(fn);
        return AppliedCombineFn.create(clonedFn, accumCoder, sideInputViews, kvCoder, windowingStrategy);
    }

    @VisibleForTesting
    public static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> withInputCoder(CombineFnBase.PerKeyCombineFn<? super K, ? super InputT, AccumT, OutputT> fn, CoderRegistry registry, KvCoder<K, InputT> kvCoder) {
        return AppliedCombineFn.withInputCoder(fn, registry, kvCoder, null, null);
    }

    public static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> withInputCoder(CombineFnBase.PerKeyCombineFn<? super K, ? super InputT, AccumT, OutputT> fn, CoderRegistry registry, KvCoder<K, InputT> kvCoder, Iterable<PCollectionView<?>> sideInputViews, WindowingStrategy<?, ?> windowingStrategy) {
        CombineFnBase.PerKeyCombineFn<K, InputT, AccumT, OutputT> clonedFn = SerializableUtils.clone(fn);
        try {
            Coder<AccumT> accumulatorCoder = clonedFn.getAccumulatorCoder(registry, kvCoder.getKeyCoder(), kvCoder.getValueCoder());
            return AppliedCombineFn.create(clonedFn, accumulatorCoder, sideInputViews, kvCoder, windowingStrategy);
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalStateException("Could not determine coder for accumulator", e);
        }
    }

    private static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> create(CombineFnBase.PerKeyCombineFn<K, InputT, AccumT, OutputT> fn, Coder<AccumT> accumulatorCoder, Iterable<PCollectionView<?>> sideInputViews, KvCoder<K, InputT> kvCoder, WindowingStrategy<?, ?> windowingStrategy) {
        return new AppliedCombineFn<K, InputT, AccumT, OutputT>(fn, accumulatorCoder, sideInputViews, kvCoder, windowingStrategy);
    }

    public CombineFnBase.PerKeyCombineFn<K, InputT, AccumT, OutputT> getFn() {
        return this.fn;
    }

    public Iterable<PCollectionView<?>> getSideInputViews() {
        return this.sideInputViews;
    }

    public Coder<AccumT> getAccumulatorCoder() {
        return this.accumulatorCoder;
    }

    public KvCoder<K, InputT> getKvCoder() {
        return this.kvCoder;
    }

    public WindowingStrategy<?, ?> getWindowingStrategy() {
        return this.windowingStrategy;
    }
}

