/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Ordering;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.display.HasDisplayData;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFn;
import java.io.Serializable;
import java.util.Collection;
import org.joda.time.Instant;

public abstract class WindowFn<T, W extends BoundedWindow>
implements Serializable,
HasDisplayData {
    public abstract Collection<W> assignWindows(AssignContext var1) throws Exception;

    public abstract void mergeWindows(MergeContext var1) throws Exception;

    public abstract boolean isCompatible(WindowFn<?, ?> var1);

    public abstract Coder<W> windowCoder();

    public abstract W getSideInputWindow(BoundedWindow var1);

    @Deprecated
    @Experimental(value=Experimental.Kind.OUTPUT_TIME)
    public Instant getOutputTime(Instant inputTimestamp, W window) {
        return this.getOutputTimeFn().assignOutputTime(inputTimestamp, window);
    }

    @Experimental(value=Experimental.Kind.OUTPUT_TIME)
    public OutputTimeFn<? super W> getOutputTimeFn() {
        return new OutputAtEarliestAssignedTimestamp(this);
    }

    public boolean isNonMerging() {
        return false;
    }

    public boolean assignsToSingleWindow() {
        return false;
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
    }

    private static class OutputAtEarliestAssignedTimestamp<W extends BoundedWindow>
    extends OutputTimeFn.Defaults<W> {
        private final WindowFn<?, W> windowFn;

        public OutputAtEarliestAssignedTimestamp(WindowFn<?, W> windowFn) {
            this.windowFn = windowFn;
        }

        @Override
        public Instant assignOutputTime(Instant timestamp, W window) {
            return this.windowFn.getOutputTime(timestamp, window);
        }

        @Override
        public Instant combine(Instant outputTime, Instant otherOutputTime) {
            return Ordering.natural().min(outputTime, otherOutputTime);
        }

        @Override
        public boolean dependsOnlyOnEarliestInputTimestamp() {
            return true;
        }
    }

    public abstract class MergeContext {
        public abstract Collection<W> windows();

        public abstract void merge(Collection<W> var1, W var2) throws Exception;
    }

    public abstract class AssignContext {
        public abstract T element();

        public abstract Instant timestamp();

        public abstract Collection<? extends BoundedWindow> windows();
    }
}

