/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Repeatedly;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class OrFinallyTrigger<W extends BoundedWindow>
extends Trigger<W> {
    private static final int ACTUAL = 0;
    private static final int UNTIL = 1;

    @VisibleForTesting
    OrFinallyTrigger(Trigger<W> actual, Trigger.OnceTrigger<W> until) {
        super(Arrays.asList(actual, until));
    }

    @Override
    public void onElement(Trigger.OnElementContext c) throws Exception {
        c.trigger().subTrigger(0).invokeOnElement(c);
        c.trigger().subTrigger(1).invokeOnElement(c);
    }

    @Override
    public void onMerge(Trigger.OnMergeContext c) throws Exception {
        for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokeOnMerge(c);
        }
        this.updateFinishedState(c);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        Instant untilDeadline;
        Instant actualDeadline = ((Trigger)this.subTriggers.get(0)).getWatermarkThatGuaranteesFiring(window);
        return actualDeadline.isBefore((ReadableInstant)(untilDeadline = ((Trigger)this.subTriggers.get(1)).getWatermarkThatGuaranteesFiring(window))) ? actualDeadline : untilDeadline;
    }

    @Override
    public Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return Repeatedly.forever(new OrFinallyTrigger<W>(continuationTriggers.get(0), (Trigger.OnceTrigger)continuationTriggers.get(1)));
    }

    @Override
    public boolean shouldFire(Trigger.TriggerContext context) throws Exception {
        return context.trigger().subTrigger(0).invokeShouldFire(context) || context.trigger().subTrigger(1).invokeShouldFire(context);
    }

    @Override
    public void onFire(Trigger.TriggerContext context) throws Exception {
        ExecutableTrigger actualSubtrigger = context.trigger().subTrigger(0);
        ExecutableTrigger untilSubtrigger = context.trigger().subTrigger(1);
        if (untilSubtrigger.invokeShouldFire(context)) {
            untilSubtrigger.invokeOnFire(context);
            actualSubtrigger.invokeClear(context);
        } else {
            actualSubtrigger.invokeOnFire(context);
        }
        this.updateFinishedState(context);
    }

    @Override
    public String toString() {
        return String.format("%s.orFinally(%s)", this.subTriggers.get(0), this.subTriggers.get(1));
    }

    private void updateFinishedState(Trigger.TriggerContext c) throws Exception {
        boolean anyStillFinished = false;
        for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
            anyStillFinished |= c.forTrigger(subTrigger).trigger().isFinished();
        }
        c.trigger().setFinished(anyStillFinished);
    }
}

