/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.windowing.IntervalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PartitioningWindowFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import java.util.Objects;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class FixedWindows
extends PartitioningWindowFn<Object, IntervalWindow> {
    private final Duration size;
    private final Duration offset;

    public static FixedWindows of(Duration size) {
        return new FixedWindows(size, Duration.ZERO);
    }

    public FixedWindows withOffset(Duration offset) {
        return new FixedWindows(this.size, offset);
    }

    private FixedWindows(Duration size, Duration offset) {
        if (offset.isShorterThan((ReadableDuration)Duration.ZERO) || !offset.isShorterThan((ReadableDuration)size)) {
            throw new IllegalArgumentException("FixedWindows WindowingStrategies must have 0 <= offset < size");
        }
        this.size = size;
        this.offset = offset;
    }

    @Override
    public IntervalWindow assignWindow(Instant timestamp) {
        long start = timestamp.getMillis() - timestamp.plus((ReadableDuration)this.size).minus((ReadableDuration)this.offset).getMillis() % this.size.getMillis();
        return new IntervalWindow(new Instant(start), (ReadableDuration)this.size);
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("size", this.size).withLabel("Window Duration")).addIfNotDefault(DisplayData.item("offset", this.offset).withLabel("Window Start Offset"), Duration.ZERO);
    }

    @Override
    public Coder<IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        return this.equals(other);
    }

    public Duration getSize() {
        return this.size;
    }

    public Duration getOffset() {
        return this.offset;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FixedWindows)) {
            return false;
        }
        FixedWindows other = (FixedWindows)object;
        return this.getOffset().equals((Object)other.getOffset()) && this.getSize().equals((Object)other.getSize());
    }

    public int hashCode() {
        return Objects.hash(this.size, this.offset);
    }
}

