/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.VarLongCoder;
import com.google.cloud.dataflow.sdk.transforms.Sum;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.state.AccumulatorCombiningState;
import com.google.cloud.dataflow.sdk.util.state.MergingStateAccessor;
import com.google.cloud.dataflow.sdk.util.state.StateAccessor;
import com.google.cloud.dataflow.sdk.util.state.StateMerging;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;
import java.util.List;
import java.util.Objects;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterPane<W extends BoundedWindow>
extends Trigger.OnceTrigger<W> {
    private static final StateTag<Object, AccumulatorCombiningState<Long, long[], Long>> ELEMENTS_IN_PANE_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("count", VarLongCoder.of(), new Sum.SumLongFn()));
    private final int countElems;

    private AfterPane(int countElems) {
        super(null);
        this.countElems = countElems;
    }

    public static <W extends BoundedWindow> AfterPane<W> elementCountAtLeast(int countElems) {
        return new AfterPane<W>(countElems);
    }

    @Override
    public void onElement(Trigger.OnElementContext c) throws Exception {
        c.state().access(ELEMENTS_IN_PANE_TAG).add(1L);
    }

    @Override
    public void prefetchOnMerge(MergingStateAccessor<?, W> state) {
        super.prefetchOnMerge(state);
        StateMerging.prefetchCombiningValues(state, ELEMENTS_IN_PANE_TAG);
    }

    @Override
    public void onMerge(Trigger.OnMergeContext context) throws Exception {
        if (context.trigger().finishedInAnyMergingWindow()) {
            context.trigger().setFinished(true);
            StateMerging.clear(context.state(), ELEMENTS_IN_PANE_TAG);
            return;
        }
        StateMerging.mergeCombiningValues(context.state(), ELEMENTS_IN_PANE_TAG);
    }

    @Override
    public void prefetchShouldFire(StateAccessor<?> state) {
        state.access(ELEMENTS_IN_PANE_TAG).readLater();
    }

    @Override
    public boolean shouldFire(Trigger.TriggerContext context) throws Exception {
        long count = (Long)context.state().access(ELEMENTS_IN_PANE_TAG).read();
        return count >= (long)this.countElems;
    }

    @Override
    public void clear(Trigger.TriggerContext c) throws Exception {
        c.state().access(ELEMENTS_IN_PANE_TAG).clear();
    }

    @Override
    public boolean isCompatible(Trigger<?> other) {
        return this.equals(other);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    public Trigger.OnceTrigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return AfterPane.elementCountAtLeast(1);
    }

    @Override
    public String toString() {
        return "AfterPane.elementCountAtLeast(" + this.countElems + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterPane)) {
            return false;
        }
        AfterPane that = (AfterPane)obj;
        return this.countElems == that.countElems;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.countElems);
    }

    @Override
    protected void onOnlyFiring(Trigger.TriggerContext context) throws Exception {
        this.clear(context);
    }
}

