/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterFirst<W extends BoundedWindow>
extends Trigger.OnceTrigger<W> {
    AfterFirst(List<Trigger<W>> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    @SafeVarargs
    public static <W extends BoundedWindow> Trigger.OnceTrigger<W> of(Trigger.OnceTrigger<W> ... triggers) {
        return new AfterFirst<W>(Arrays.asList(triggers));
    }

    @Override
    public void onElement(Trigger.OnElementContext c) throws Exception {
        for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokeOnElement(c);
        }
    }

    @Override
    public void onMerge(Trigger.OnMergeContext c) throws Exception {
        for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokeOnMerge(c);
        }
        this.updateFinishedStatus(c);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        Instant deadline = BoundedWindow.TIMESTAMP_MAX_VALUE;
        for (Trigger subTrigger : this.subTriggers) {
            Instant subDeadline = subTrigger.getWatermarkThatGuaranteesFiring(window);
            if (!deadline.isAfter((ReadableInstant)subDeadline)) continue;
            deadline = subDeadline;
        }
        return deadline;
    }

    @Override
    public Trigger.OnceTrigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return new AfterFirst<W>(continuationTriggers);
    }

    @Override
    public boolean shouldFire(Trigger.TriggerContext context) throws Exception {
        for (ExecutableTrigger subtrigger : context.trigger().subTriggers()) {
            if (!context.forTrigger(subtrigger).trigger().isFinished() && !subtrigger.invokeShouldFire(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onOnlyFiring(Trigger.TriggerContext context) throws Exception {
        for (ExecutableTrigger subtrigger : context.trigger().subTriggers()) {
            Trigger.TriggerContext subContext;
            if (subtrigger.invokeShouldFire(subContext = context.forTrigger(subtrigger))) {
                subtrigger.invokeOnFire(subContext);
                continue;
            }
            subtrigger.invokeClear(subContext);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterFirst.of(");
        Joiner.on(", ").appendTo(builder, (Iterable<?>)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }

    private void updateFinishedStatus(Trigger.TriggerContext c) {
        boolean anyFinished = false;
        for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
            anyFinished |= c.forTrigger(subTrigger).trigger().isFinished();
        }
        c.trigger().setFinished(anyFinished);
    }
}

