/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.join;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TupleTagList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoGbkResultSchema
implements Serializable {
    private final TupleTagList tupleTagList;
    private final HashMap<TupleTag<?>, Integer> tagMap = new HashMap();

    @JsonCreator
    public static CoGbkResultSchema of(@JsonProperty(value="tuple_tags") List<TupleTag<?>> tags) {
        TupleTagList tupleTags = TupleTagList.empty();
        for (TupleTag<?> tag : tags) {
            tupleTags = tupleTags.and(tag);
        }
        return new CoGbkResultSchema(tupleTags);
    }

    public CoGbkResultSchema(TupleTagList tupleTagList) {
        this.tupleTagList = tupleTagList;
        int index = -1;
        for (TupleTag<?> tag : tupleTagList.getAll()) {
            this.tagMap.put(tag, ++index);
        }
    }

    public int getIndex(TupleTag<?> tag) {
        Integer index = this.tagMap.get(tag);
        return index == null ? -1 : index;
    }

    public TupleTag<?> getTag(int index) {
        return this.tupleTagList.get(index);
    }

    public int size() {
        return this.tupleTagList.getAll().size();
    }

    public TupleTagList getTupleTagList() {
        return this.tupleTagList;
    }

    public CloudObject asCloudObject() {
        CloudObject result = CloudObject.forClass(this.getClass());
        ArrayList<CloudObject> serializedTags = new ArrayList<CloudObject>(this.tupleTagList.size());
        for (TupleTag<?> tag : this.tupleTagList.getAll()) {
            serializedTags.add(tag.asCloudObject());
        }
        Structs.addList((Map<String, Object>)((Object)result), "tuple_tags", serializedTags);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CoGbkResultSchema)) {
            return false;
        }
        CoGbkResultSchema other = (CoGbkResultSchema)obj;
        return this.tupleTagList.getAll().equals(other.tupleTagList.getAll());
    }

    public int hashCode() {
        return this.tupleTagList.getAll().hashCode();
    }

    public String toString() {
        return "CoGbkResultSchema: " + this.tupleTagList.getAll();
    }
}

