/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.SimpleFunction;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;

public class MapElements<InputT, OutputT>
extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
    private final SerializableFunction<InputT, OutputT> fn;
    private final transient TypeDescriptor<OutputT> outputType;

    public static <InputT, OutputT> MissingOutputTypeDescriptor<InputT, OutputT> via(SerializableFunction<InputT, OutputT> fn) {
        return new MissingOutputTypeDescriptor(fn);
    }

    public static <InputT, OutputT> MapElements<InputT, OutputT> via(SimpleFunction<InputT, OutputT> fn) {
        return new MapElements<InputT, OutputT>(fn, fn.getOutputTypeDescriptor());
    }

    private MapElements(SerializableFunction<InputT, OutputT> fn, TypeDescriptor<OutputT> outputType) {
        this.fn = fn;
        this.outputType = outputType;
    }

    @Override
    public PCollection<OutputT> apply(PCollection<InputT> input) {
        return ((PCollection)input.apply(ParDo.named("Map").of(new DoFn<InputT, OutputT>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                c.output(MapElements.this.fn.apply(c.element()));
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                MapElements.this.populateDisplayData(builder);
            }
        }))).setTypeDescriptorInternal((TypeDescriptor)this.outputType);
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("mapFn", this.fn.getClass()).withLabel("Map Function"));
    }

    public static final class MissingOutputTypeDescriptor<InputT, OutputT> {
        private final SerializableFunction<InputT, OutputT> fn;

        private MissingOutputTypeDescriptor(SerializableFunction<InputT, OutputT> fn) {
            this.fn = fn;
        }

        public MapElements<InputT, OutputT> withOutputType(TypeDescriptor<OutputT> outputType) {
            return new MapElements(this.fn, outputType);
        }
    }
}

