/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.values.PCollection;

public class Filter<T>
extends PTransform<PCollection<T>, PCollection<T>> {
    private SerializableFunction<T, Boolean> predicate;

    public static <T, PredicateT extends SerializableFunction<T, Boolean>> Filter<T> byPredicate(PredicateT predicate) {
        return new Filter<T>("Filter", predicate);
    }

    @Deprecated
    public static <T, PredicateT extends SerializableFunction<T, Boolean>> ParDo.Bound<T, T> by(final PredicateT filterPred) {
        return ParDo.named("Filter").of(new DoFn<T, T>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                if (((Boolean)filterPred.apply(c.element())).booleanValue()) {
                    c.output(c.element());
                }
            }
        });
    }

    public static <T extends Comparable<T>> ParDo.Bound<T, T> lessThan(final T value) {
        return ParDo.named("Filter.lessThan").of(new DoFn<T, T>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                if (((Comparable)c.element()).compareTo(value) < 0) {
                    c.output(c.element());
                }
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                Filter.populateDisplayData(builder, String.format("x < %s", value));
            }
        });
    }

    public static <T extends Comparable<T>> ParDo.Bound<T, T> greaterThan(final T value) {
        return ParDo.named("Filter.greaterThan").of(new DoFn<T, T>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                if (((Comparable)c.element()).compareTo(value) > 0) {
                    c.output(c.element());
                }
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                Filter.populateDisplayData(builder, String.format("x > %s", value));
            }
        });
    }

    public static <T extends Comparable<T>> ParDo.Bound<T, T> lessThanEq(final T value) {
        return ParDo.named("Filter.lessThanEq").of(new DoFn<T, T>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                if (((Comparable)c.element()).compareTo(value) <= 0) {
                    c.output(c.element());
                }
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                Filter.populateDisplayData(builder, String.format("x \u2264 %s", value));
            }
        });
    }

    public static <T extends Comparable<T>> ParDo.Bound<T, T> greaterThanEq(final T value) {
        return ParDo.named("Filter.greaterThanEq").of(new DoFn<T, T>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                if (((Comparable)c.element()).compareTo(value) >= 0) {
                    c.output(c.element());
                }
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                Filter.populateDisplayData(builder, String.format("x \u2265 %s", value));
            }
        });
    }

    private Filter(SerializableFunction<T, Boolean> predicate) {
        this.predicate = predicate;
    }

    private Filter(String name, SerializableFunction<T, Boolean> predicate) {
        super(name);
        this.predicate = predicate;
    }

    public Filter<T> named(String name) {
        return new Filter<T>(name, this.predicate);
    }

    @Override
    public PCollection<T> apply(PCollection<T> input) {
        PCollection output = (PCollection)input.apply(ParDo.named("Filter").of(new DoFn<T, T>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                if (((Boolean)Filter.this.predicate.apply(c.element())).booleanValue()) {
                    c.output(c.element());
                }
            }
        }));
        return output;
    }

    @Override
    protected Coder<T> getDefaultOutputCoder(PCollection<T> input) {
        return input.getCoder();
    }

    private static void populateDisplayData(DisplayData.Builder builder, String predicateDescription) {
        builder.add(DisplayData.item("predicate", predicateDescription).withLabel("Filter Predicate"));
    }
}

