/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Objects;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;

public class AppliedPTransform<InputT extends PInput, OutputT extends POutput, TransformT extends PTransform<? super InputT, OutputT>> {
    private final String fullName;
    private final InputT input;
    private final OutputT output;
    private final TransformT transform;

    private AppliedPTransform(String fullName, InputT input, OutputT output, TransformT transform) {
        this.input = input;
        this.output = output;
        this.transform = transform;
        this.fullName = fullName;
    }

    public static <InputT extends PInput, OutputT extends POutput, TransformT extends PTransform<? super InputT, OutputT>> AppliedPTransform<InputT, OutputT, TransformT> of(String fullName, InputT input, OutputT output, TransformT transform) {
        return new AppliedPTransform<InputT, OutputT, TransformT>(fullName, input, output, transform);
    }

    public String getFullName() {
        return this.fullName;
    }

    public InputT getInput() {
        return this.input;
    }

    public OutputT getOutput() {
        return this.output;
    }

    public TransformT getTransform() {
        return this.transform;
    }

    public int hashCode() {
        return Objects.hashCode(this.getFullName(), this.getInput(), this.getOutput(), this.getTransform());
    }

    public boolean equals(Object other) {
        if (other instanceof AppliedPTransform) {
            AppliedPTransform that = (AppliedPTransform)other;
            return Objects.equal(this.getFullName(), that.getFullName()) && Objects.equal(this.getInput(), that.getInput()) && Objects.equal(this.getOutput(), that.getOutput()) && Objects.equal(this.getTransform(), that.getTransform());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("fullName", this.getFullName()).add("input", this.getInput()).add("output", this.getOutput()).add("transform", this.getTransform()).toString();
    }
}

