/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.io.Read;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.runners.inprocess.BoundedReadEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.FlattenEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.GroupByKeyEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessEvaluationContext;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.ParDoMultiEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.ParDoSingleEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.TestStreamEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformEvaluator;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.UnboundedReadEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.ViewEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.WindowEvaluatorFactory;
import com.google.cloud.dataflow.sdk.testing.TestStream;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.Flatten;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.windowing.Window;
import java.util.Map;
import javax.annotation.Nullable;

class TransformEvaluatorRegistry
implements TransformEvaluatorFactory {
    private final Map<Class<? extends PTransform>, TransformEvaluatorFactory> factories;

    public static TransformEvaluatorRegistry defaultRegistry() {
        ImmutableMap<Class<? extends PTransform>, TransformEvaluatorFactory> primitives = ImmutableMap.builder().put(Read.Bounded.class, new BoundedReadEvaluatorFactory()).put(Read.Unbounded.class, (BoundedReadEvaluatorFactory)((Object)new UnboundedReadEvaluatorFactory())).put(ParDo.Bound.class, (BoundedReadEvaluatorFactory)((Object)new ParDoSingleEvaluatorFactory())).put(ParDo.BoundMulti.class, (BoundedReadEvaluatorFactory)((Object)new ParDoMultiEvaluatorFactory())).put(GroupByKeyEvaluatorFactory.InProcessGroupByKeyOnly.class, (BoundedReadEvaluatorFactory)((Object)new GroupByKeyEvaluatorFactory())).put(Flatten.FlattenPCollectionList.class, (BoundedReadEvaluatorFactory)((Object)new FlattenEvaluatorFactory())).put(ViewEvaluatorFactory.WriteView.class, (BoundedReadEvaluatorFactory)((Object)new ViewEvaluatorFactory())).put(Window.Bound.class, (BoundedReadEvaluatorFactory)((Object)new WindowEvaluatorFactory())).put(TestStream.class, (BoundedReadEvaluatorFactory)((Object)new TestStreamEvaluatorFactory())).build();
        return new TransformEvaluatorRegistry(primitives);
    }

    private TransformEvaluatorRegistry(Map<Class<? extends PTransform>, TransformEvaluatorFactory> factories) {
        this.factories = factories;
    }

    @Override
    public <InputT> TransformEvaluator<InputT> forApplication(AppliedPTransform<?, ?, ?> application, @Nullable InProcessPipelineRunner.CommittedBundle<?> inputBundle, InProcessEvaluationContext evaluationContext) throws Exception {
        TransformEvaluatorFactory factory = this.factories.get(application.getTransform().getClass());
        return factory.forApplication(application, inputBundle, evaluationContext);
    }

    public static class Factory {
        public TransformEvaluatorRegistry create() {
            return TransformEvaluatorRegistry.defaultRegistry();
        }
    }
}

