/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.ExecutionError;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.cloud.dataflow.sdk.runners.inprocess.KeyedResourcePool;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

class LockedKeyedResourcePool<K, V>
implements KeyedResourcePool<K, V> {
    private final ConcurrentMap<K, Optional<V>> cache = new ConcurrentHashMap<K, Optional<V>>();

    public static <K, V> LockedKeyedResourcePool<K, V> create() {
        return new LockedKeyedResourcePool<K, V>();
    }

    private LockedKeyedResourcePool() {
    }

    @Override
    public Optional<V> tryAcquire(K key, Callable<V> loader) throws ExecutionException {
        Optional value = this.cache.replace(key, Optional.absent());
        if (value == null) {
            this.cache.putIfAbsent(key, Optional.of(this.load(loader)));
            value = this.cache.replace(key, Optional.absent());
        }
        return value;
    }

    private V load(Callable<V> loader) throws ExecutionException {
        try {
            return loader.call();
        }
        catch (Error t) {
            throw new ExecutionError(t);
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public void release(K key, V value) {
        Optional<V> replaced = this.cache.replace(key, Optional.of(value));
        Preconditions.checkNotNull(replaced, "Tried to release before a value was acquired");
        Preconditions.checkState(!replaced.isPresent(), "Released a value to a %s where there is already a value present for key %s (%s). At most one value may be present at a time.", LockedKeyedResourcePool.class.getSimpleName(), key, replaced);
    }
}

