/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.runners.TransformTreeNode;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.HashSet;
import java.util.Set;

class KeyedPValueTrackingVisitor
implements Pipeline.PipelineVisitor {
    private final Set<Class<? extends PTransform>> producesKeyedOutputs;
    private final Set<PValue> keyedValues;
    private boolean finalized;

    public static KeyedPValueTrackingVisitor create(Set<Class<? extends PTransform>> producesKeyedOutputs) {
        return new KeyedPValueTrackingVisitor(producesKeyedOutputs);
    }

    private KeyedPValueTrackingVisitor(Set<Class<? extends PTransform>> producesKeyedOutputs) {
        this.producesKeyedOutputs = producesKeyedOutputs;
        this.keyedValues = new HashSet<PValue>();
    }

    @Override
    public void enterCompositeTransform(TransformTreeNode node) {
        Preconditions.checkState(!this.finalized, "Attempted to use a %s that has already been finalized on a pipeline (visiting node %s)", KeyedPValueTrackingVisitor.class.getSimpleName(), node);
    }

    @Override
    public void leaveCompositeTransform(TransformTreeNode node) {
        Preconditions.checkState(!this.finalized, "Attempted to use a %s that has already been finalized on a pipeline (visiting node %s)", KeyedPValueTrackingVisitor.class.getSimpleName(), node);
        if (node.isRootNode()) {
            this.finalized = true;
        } else if (this.producesKeyedOutputs.contains(node.getTransform().getClass())) {
            this.keyedValues.addAll(node.getExpandedOutputs());
        }
    }

    @Override
    public void visitTransform(TransformTreeNode node) {
    }

    @Override
    public void visitValue(PValue value, TransformTreeNode producer) {
        if (this.producesKeyedOutputs.contains(producer.getTransform().getClass())) {
            this.keyedValues.addAll(value.expand());
        }
    }

    public Set<PValue> getKeyedPValues() {
        Preconditions.checkState(this.finalized, "can't call getKeyedPValues before a Pipeline has been completely traversed");
        return this.keyedValues;
    }
}

