/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.PipelineResult;
import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.io.Write;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Supplier;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Suppliers;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.dataflow.sdk.runners.AggregatorPipelineExtractor;
import com.google.cloud.dataflow.sdk.runners.AggregatorRetrievalException;
import com.google.cloud.dataflow.sdk.runners.AggregatorValues;
import com.google.cloud.dataflow.sdk.runners.PipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.BundleFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.Clock;
import com.google.cloud.dataflow.sdk.runners.inprocess.ConsumerTrackingPipelineVisitor;
import com.google.cloud.dataflow.sdk.runners.inprocess.DisplayDataValidator;
import com.google.cloud.dataflow.sdk.runners.inprocess.ExecutorServiceFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.ExecutorServiceParallelExecutor;
import com.google.cloud.dataflow.sdk.runners.inprocess.GroupByKeyEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.ImmutabilityCheckingBundleFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.ImmutabilityEnforcementFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessBundleFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessCreate;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessEvaluationContext;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessExecutor;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineOptions;
import com.google.cloud.dataflow.sdk.runners.inprocess.KeyedPValueTrackingVisitor;
import com.google.cloud.dataflow.sdk.runners.inprocess.ModelEnforcementFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.NanosOffsetClock;
import com.google.cloud.dataflow.sdk.runners.inprocess.PTransformOverrideFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.StructuralKey;
import com.google.cloud.dataflow.sdk.runners.inprocess.TestStreamEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformEvaluatorRegistry;
import com.google.cloud.dataflow.sdk.runners.inprocess.ViewEvaluatorFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.WriteWithShardingFactory;
import com.google.cloud.dataflow.sdk.testing.TestStream;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.Create;
import com.google.cloud.dataflow.sdk.transforms.GroupByKey;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.View;
import com.google.cloud.dataflow.sdk.util.MapAggregatorValues;
import com.google.cloud.dataflow.sdk.util.UserCodeException;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.Instant;

@Experimental
public class InProcessPipelineRunner
extends PipelineRunner<InProcessPipelineResult> {
    private static Map<Class<? extends PTransform>, PTransformOverrideFactory> defaultTransformOverrides = ImmutableMap.builder().put(Create.Values.class, new InProcessCreate.InProcessCreateOverrideFactory()).put(GroupByKey.class, (InProcessCreate.InProcessCreateOverrideFactory)((Object)new GroupByKeyEvaluatorFactory.InProcessGroupByKeyOverrideFactory())).put(View.CreatePCollectionView.class, (InProcessCreate.InProcessCreateOverrideFactory)((Object)new ViewEvaluatorFactory.InProcessViewOverrideFactory())).put(TestStream.class, (InProcessCreate.InProcessCreateOverrideFactory)((Object)new TestStreamEvaluatorFactory.InProcessTestStreamFactory())).put(Write.Bound.class, (InProcessCreate.InProcessCreateOverrideFactory)((Object)new WriteWithShardingFactory())).build();
    private final InProcessPipelineOptions options;
    private Supplier<ExecutorService> executorServiceSupplier;
    private Supplier<Clock> clockSupplier;

    public static InProcessPipelineRunner fromOptions(PipelineOptions options) {
        return new InProcessPipelineRunner(options.as(InProcessPipelineOptions.class));
    }

    private InProcessPipelineRunner(InProcessPipelineOptions options) {
        this.options = options;
        this.executorServiceSupplier = options.getExecutorServiceFactory() == null ? new FixedThreadPoolSupplier() : new ExecutorServiceFactorySupplier(options.getExecutorServiceFactory());
        this.clockSupplier = options.getClock() == null ? new NanosOffsetClockSupplier() : Suppliers.ofInstance(options.getClock());
    }

    public InProcessPipelineOptions getPipelineOptions() {
        return this.options;
    }

    Supplier<Clock> getClockSupplier() {
        return this.clockSupplier;
    }

    void setClockSupplier(Supplier<Clock> supplier) {
        this.clockSupplier = supplier;
    }

    @Override
    public <OutputT extends POutput, InputT extends PInput> OutputT apply(PTransform<InputT, OutputT> transform, InputT input) {
        PTransformOverrideFactory overrideFactory = defaultTransformOverrides.get(transform.getClass());
        if (overrideFactory != null) {
            PTransform<InputT, OutputT> customTransform = overrideFactory.override(transform);
            return super.apply(customTransform, input);
        }
        return super.apply(transform, input);
    }

    @Override
    public InProcessPipelineResult run(Pipeline pipeline) {
        ConsumerTrackingPipelineVisitor consumerTrackingVisitor = new ConsumerTrackingPipelineVisitor();
        pipeline.traverseTopologically(consumerTrackingVisitor);
        for (PValue unfinalized : consumerTrackingVisitor.getUnfinalizedPValues()) {
            unfinalized.finishSpecifying();
        }
        KeyedPValueTrackingVisitor keyedPValueVisitor = KeyedPValueTrackingVisitor.create(ImmutableSet.of(GroupByKey.class, GroupByKeyEvaluatorFactory.InProcessGroupByKeyOnly.class));
        pipeline.traverseTopologically(keyedPValueVisitor);
        DisplayDataValidator.validatePipeline(pipeline);
        InProcessEvaluationContext context = InProcessEvaluationContext.create(this.getPipelineOptions(), this.clockSupplier.get(), this.createBundleFactory(this.getPipelineOptions()), consumerTrackingVisitor.getRootTransforms(), consumerTrackingVisitor.getValueToConsumers(), consumerTrackingVisitor.getStepNames(), consumerTrackingVisitor.getViews());
        ExecutorService executorService = this.executorServiceSupplier.get();
        TransformEvaluatorRegistry registry = TransformEvaluatorRegistry.defaultRegistry();
        ExecutorServiceParallelExecutor executor = ExecutorServiceParallelExecutor.create(executorService, consumerTrackingVisitor.getValueToConsumers(), keyedPValueVisitor.getKeyedPValues(), registry, this.defaultModelEnforcements(this.options), context);
        executor.start(consumerTrackingVisitor.getRootTransforms());
        Map<Aggregator<?, ?>, Collection<PTransform<?, ?>>> aggregatorSteps = new AggregatorPipelineExtractor(pipeline).getAggregatorSteps();
        InProcessPipelineResult result = new InProcessPipelineResult(executor, context, aggregatorSteps);
        if (this.options.isBlockOnRun()) {
            try {
                result.awaitCompletion();
            }
            catch (UserCodeException userException) {
                throw new Pipeline.PipelineExecutionException(userException.getCause());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return result;
    }

    private Map<Class<? extends PTransform>, Collection<ModelEnforcementFactory>> defaultModelEnforcements(InProcessPipelineOptions options) {
        ImmutableMap.Builder<Class, Collection<ModelEnforcementFactory>> enforcements = ImmutableMap.builder();
        Collection<ModelEnforcementFactory> parDoEnforcements = this.createParDoEnforcements(options);
        enforcements.put(ParDo.Bound.class, parDoEnforcements);
        enforcements.put(ParDo.BoundMulti.class, parDoEnforcements);
        return enforcements.build();
    }

    private Collection<ModelEnforcementFactory> createParDoEnforcements(InProcessPipelineOptions options) {
        ImmutableList.Builder enforcements = ImmutableList.builder();
        if (options.isTestImmutability()) {
            enforcements.add(ImmutabilityEnforcementFactory.create());
        }
        return enforcements.build();
    }

    private BundleFactory createBundleFactory(InProcessPipelineOptions pipelineOptions) {
        BundleFactory bundleFactory = InProcessBundleFactory.create();
        if (pipelineOptions.isTestImmutability()) {
            bundleFactory = ImmutabilityCheckingBundleFactory.create(bundleFactory);
        }
        return bundleFactory;
    }

    private static class NanosOffsetClockSupplier
    implements Supplier<Clock> {
        private NanosOffsetClockSupplier() {
        }

        @Override
        public Clock get() {
            return NanosOffsetClock.create();
        }
    }

    private static class ExecutorServiceFactorySupplier
    implements Supplier<ExecutorService> {
        private final ExecutorServiceFactory executorServiceFactory;

        public ExecutorServiceFactorySupplier(ExecutorServiceFactory executorServiceFactory) {
            this.executorServiceFactory = executorServiceFactory;
        }

        @Override
        public ExecutorService get() {
            return this.executorServiceFactory.create();
        }
    }

    private static class FixedThreadPoolSupplier
    implements Supplier<ExecutorService> {
        private FixedThreadPoolSupplier() {
        }

        @Override
        public ExecutorService get() {
            return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        }
    }

    public static class InProcessPipelineResult
    implements PipelineResult {
        private final InProcessExecutor executor;
        private final InProcessEvaluationContext evaluationContext;
        private final Map<Aggregator<?, ?>, Collection<PTransform<?, ?>>> aggregatorSteps;
        private PipelineResult.State state;

        private InProcessPipelineResult(InProcessExecutor executor, InProcessEvaluationContext evaluationContext, Map<Aggregator<?, ?>, Collection<PTransform<?, ?>>> aggregatorSteps) {
            this.executor = executor;
            this.evaluationContext = evaluationContext;
            this.aggregatorSteps = aggregatorSteps;
            this.state = PipelineResult.State.RUNNING;
        }

        @Override
        public PipelineResult.State getState() {
            return this.state;
        }

        @Override
        public <T> AggregatorValues<T> getAggregatorValues(Aggregator<?, T> aggregator) throws AggregatorRetrievalException {
            CounterSet counters = this.evaluationContext.getCounters();
            Collection<PTransform<?, ?>> steps = this.aggregatorSteps.get(aggregator);
            HashMap stepValues = new HashMap();
            for (AppliedPTransform<?, ?, ?> transform : this.evaluationContext.getSteps()) {
                String stepName;
                Counter<?> counter;
                if (!steps.contains(transform.getTransform()) || (counter = counters.getExistingCounter(stepName = String.format("user-%s-%s", this.evaluationContext.getStepName(transform), aggregator.getName()))) == null) continue;
                stepValues.put(transform.getFullName(), counter.getAggregate());
            }
            return new MapAggregatorValues(stepValues);
        }

        public PipelineResult.State awaitCompletion() throws Throwable {
            if (!this.state.isTerminal()) {
                try {
                    this.executor.awaitCompletion();
                    this.state = PipelineResult.State.DONE;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
                catch (Throwable t) {
                    this.state = PipelineResult.State.FAILED;
                    throw t;
                }
            }
            return this.state;
        }
    }

    public static interface PCollectionViewWriter<ElemT, ViewT> {
        public void add(Iterable<WindowedValue<ElemT>> var1);
    }

    public static interface CommittedBundle<T> {
        public PCollection<T> getPCollection();

        public StructuralKey<?> getKey();

        public Iterable<WindowedValue<T>> getElements();

        public Instant getSynchronizedProcessingOutputWatermark();

        public CommittedBundle<T> withElements(Iterable<WindowedValue<T>> var1);
    }

    public static interface UncommittedBundle<T> {
        public PCollection<T> getPCollection();

        public UncommittedBundle<T> add(WindowedValue<T> var1);

        public CommittedBundle<T> commit(Instant var1);
    }
}

