/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.io.BoundedSource;
import com.google.cloud.dataflow.sdk.io.OffsetBasedSource;
import com.google.cloud.dataflow.sdk.io.Read;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.runners.inprocess.ForwardingPTransform;
import com.google.cloud.dataflow.sdk.runners.inprocess.PTransformOverrideFactory;
import com.google.cloud.dataflow.sdk.transforms.Create;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

class InProcessCreate<T>
extends ForwardingPTransform<PInput, PCollection<T>> {
    private final Create.Values<T> original;

    public static <T> InProcessCreate<T> from(Create.Values<T> original) {
        return new InProcessCreate<T>(original);
    }

    private InProcessCreate(Create.Values<T> original) {
        this.original = original;
    }

    @Override
    public PCollection<T> apply(PInput input) {
        InMemorySource<T> source;
        Coder<T> elementCoder;
        try {
            elementCoder = this.original.getDefaultOutputCoder(input);
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalArgumentException("Unable to infer a coder and no Coder was specified. Please set a coder by invoking Create.withCoder() explicitly.", e);
        }
        try {
            source = InMemorySource.fromIterable(this.original.getElements(), elementCoder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PCollection result = (PCollection)input.getPipeline().apply(Read.from(source));
        result.setCoder((Coder)elementCoder);
        return result;
    }

    @Override
    public PTransform<PInput, PCollection<T>> delegate() {
        return this.original;
    }

    private static class BytesReader<T>
    extends OffsetBasedSource.OffsetBasedReader<T> {
        private int index = -1;
        @Nullable
        private Optional<T> next;

        public BytesReader(InMemorySource<T> source) {
            super(source);
        }

        @Override
        @Nullable
        public T getCurrent() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next.orNull();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        protected long getCurrentOffset() {
            return this.index;
        }

        @Override
        protected boolean startImpl() throws IOException {
            return this.advanceImpl();
        }

        @Override
        public synchronized InMemorySource<T> getCurrentSource() {
            return (InMemorySource)super.getCurrentSource();
        }

        @Override
        protected boolean advanceImpl() throws IOException {
            OffsetBasedSource source = this.getCurrentSource();
            ++this.index;
            if (this.index >= ((InMemorySource)source).allElementsBytes.size()) {
                return false;
            }
            this.next = Optional.fromNullable(CoderUtils.decodeFromByteArray(((InMemorySource)source).coder, (byte[])((InMemorySource)source).allElementsBytes.get(this.index)));
            return true;
        }
    }

    @VisibleForTesting
    static class InMemorySource<T>
    extends OffsetBasedSource<T> {
        private final List<byte[]> allElementsBytes;
        private final long totalSize;
        private final Coder<T> coder;

        public static <T> InMemorySource<T> fromIterable(Iterable<T> elements, Coder<T> elemCoder) throws CoderException, IOException {
            ImmutableList.Builder allElementsBytes = ImmutableList.builder();
            long totalSize = 0L;
            for (T element : elements) {
                byte[] bytes = CoderUtils.encodeToByteArray(elemCoder, element);
                allElementsBytes.add((Object)bytes);
                totalSize += (long)bytes.length;
            }
            return new InMemorySource<T>((List<byte[]>)((Object)allElementsBytes.build()), totalSize, elemCoder);
        }

        private InMemorySource(List<byte[]> elementBytes, long totalSize, Coder<T> coder) {
            super(0L, elementBytes.size(), 1L);
            this.allElementsBytes = ImmutableList.copyOf(elementBytes);
            this.totalSize = totalSize;
            this.coder = coder;
        }

        @Override
        public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
            return this.totalSize;
        }

        @Override
        public boolean producesSortedKeys(PipelineOptions options) throws Exception {
            return false;
        }

        @Override
        public BoundedSource.BoundedReader<T> createReader(PipelineOptions options) throws IOException {
            return new BytesReader(this);
        }

        @Override
        public void validate() {
        }

        @Override
        public Coder<T> getDefaultOutputCoder() {
            return this.coder;
        }

        @Override
        public long getMaxEndOffset(PipelineOptions options) throws Exception {
            return this.allElementsBytes.size();
        }

        @Override
        public OffsetBasedSource<T> createSourceForSubrange(long start, long end) {
            List<byte[]> primaryElems = this.allElementsBytes.subList((int)start, (int)end);
            long primarySizeEstimate = (long)((double)(this.totalSize * (long)primaryElems.size()) / (double)this.allElementsBytes.size());
            return new InMemorySource<T>(primaryElems, primarySizeEstimate, this.coder);
        }

        @Override
        public long getBytesPerOffset() {
            if (this.allElementsBytes.size() == 0) {
                return 1L;
            }
            return Math.max(1L, this.totalSize / (long)this.allElementsBytes.size());
        }
    }

    public static class InProcessCreateOverrideFactory
    implements PTransformOverrideFactory {
        @Override
        public <InputT extends PInput, OutputT extends POutput> PTransform<InputT, OutputT> override(PTransform<InputT, OutputT> transform) {
            if (transform instanceof Create.Values) {
                InProcessCreate override = InProcessCreate.from((Create.Values)transform);
                return override;
            }
            return transform;
        }
    }
}

