/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.runners.inprocess.BundleFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.StructuralKey;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.values.PCollection;
import org.joda.time.Instant;

class InProcessBundleFactory
implements BundleFactory {
    public static InProcessBundleFactory create() {
        return new InProcessBundleFactory();
    }

    private InProcessBundleFactory() {
    }

    @Override
    public <T> InProcessPipelineRunner.UncommittedBundle<T> createRootBundle(PCollection<T> output) {
        return InProcessBundle.create(output, StructuralKey.of(null, VoidCoder.of()));
    }

    @Override
    public <T> InProcessPipelineRunner.UncommittedBundle<T> createBundle(InProcessPipelineRunner.CommittedBundle<?> input, PCollection<T> output) {
        return InProcessBundle.create(output, input.getKey());
    }

    @Override
    public <K, T> InProcessPipelineRunner.UncommittedBundle<T> createKeyedBundle(InProcessPipelineRunner.CommittedBundle<?> input, StructuralKey<K> key, PCollection<T> output) {
        return InProcessBundle.create(output, key);
    }

    private static class CommittedInProcessBundle<T>
    implements InProcessPipelineRunner.CommittedBundle<T> {
        private final PCollection<T> pcollection;
        private final StructuralKey<?> key;
        private final Iterable<WindowedValue<T>> committedElements;
        private final Instant synchronizedCompletionTime;

        public CommittedInProcessBundle(PCollection<T> pcollection, StructuralKey<?> key, Iterable<WindowedValue<T>> committedElements, Instant synchronizedCompletionTime) {
            this.pcollection = pcollection;
            this.key = key;
            this.committedElements = committedElements;
            this.synchronizedCompletionTime = synchronizedCompletionTime;
        }

        @Override
        public StructuralKey<?> getKey() {
            return this.key;
        }

        @Override
        public Iterable<WindowedValue<T>> getElements() {
            return this.committedElements;
        }

        @Override
        public PCollection<T> getPCollection() {
            return this.pcollection;
        }

        @Override
        public Instant getSynchronizedProcessingOutputWatermark() {
            return this.synchronizedCompletionTime;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("pcollection", this.pcollection).add("key", this.key).add("elements", this.committedElements).toString();
        }

        @Override
        public InProcessPipelineRunner.CommittedBundle<T> withElements(Iterable<WindowedValue<T>> elements) {
            return new CommittedInProcessBundle<T>(this.pcollection, this.key, ImmutableList.copyOf(elements), this.synchronizedCompletionTime);
        }
    }

    private static final class InProcessBundle<T>
    implements InProcessPipelineRunner.UncommittedBundle<T> {
        private final PCollection<T> pcollection;
        private final StructuralKey<?> key;
        private boolean committed = false;
        private ImmutableList.Builder<WindowedValue<T>> elements;

        public static <T> InProcessBundle<T> create(PCollection<T> pcollection, StructuralKey<?> key) {
            return new InProcessBundle<T>(pcollection, key);
        }

        private InProcessBundle(PCollection<T> pcollection, StructuralKey<?> key) {
            this.pcollection = pcollection;
            this.key = key;
            this.elements = ImmutableList.builder();
        }

        @Override
        public PCollection<T> getPCollection() {
            return this.pcollection;
        }

        @Override
        public InProcessBundle<T> add(WindowedValue<T> element) {
            Preconditions.checkState(!this.committed, "Can't add element %s to committed bundle in PCollection %s", element, this.pcollection);
            this.elements.add((Object)element);
            return this;
        }

        @Override
        public InProcessPipelineRunner.CommittedBundle<T> commit(Instant synchronizedCompletionTime) {
            Preconditions.checkState(!this.committed, "Can't commit already committed bundle %s", this);
            this.committed = true;
            ImmutableCollection committedElements = this.elements.build();
            return new CommittedInProcessBundle<T>(this.pcollection, this.key, committedElements, synchronizedCompletionTime);
        }
    }
}

