/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessEvaluationContext;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessTransformResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.StepTransformResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformEvaluator;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformEvaluatorFactory;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.Flatten;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionList;

class FlattenEvaluatorFactory
implements TransformEvaluatorFactory {
    FlattenEvaluatorFactory() {
    }

    @Override
    public <InputT> TransformEvaluator<InputT> forApplication(AppliedPTransform<?, ?, ?> application, InProcessPipelineRunner.CommittedBundle<?> inputBundle, InProcessEvaluationContext evaluationContext) {
        return this.createInMemoryEvaluator(application, inputBundle, evaluationContext);
    }

    private <InputT> TransformEvaluator<InputT> createInMemoryEvaluator(AppliedPTransform<PCollectionList<InputT>, PCollection<InputT>, Flatten.FlattenPCollectionList<InputT>> application, InProcessPipelineRunner.CommittedBundle<InputT> inputBundle, InProcessEvaluationContext evaluationContext) {
        if (inputBundle == null) {
            return new FlattenEvaluator(null, StepTransformResult.withoutHold(application).build());
        }
        InProcessPipelineRunner.UncommittedBundle<InputT> outputBundle = evaluationContext.createBundle(inputBundle, application.getOutput());
        StepTransformResult result = StepTransformResult.withoutHold(application).addOutput(outputBundle, new InProcessPipelineRunner.UncommittedBundle[0]).build();
        return new FlattenEvaluator<InputT>(outputBundle, result);
    }

    private static class FlattenEvaluator<InputT>
    implements TransformEvaluator<InputT> {
        private final InProcessPipelineRunner.UncommittedBundle<InputT> outputBundle;
        private final InProcessTransformResult result;

        public FlattenEvaluator(InProcessPipelineRunner.UncommittedBundle<InputT> outputBundle, InProcessTransformResult result) {
            this.outputBundle = outputBundle;
            this.result = result;
        }

        @Override
        public void processElement(WindowedValue<InputT> element) {
            this.outputBundle.add(element);
        }

        @Override
        public InProcessTransformResult finishBundle() {
            return this.result;
        }
    }
}

