/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.runners.TransformTreeNode;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.display.HasDisplayData;
import com.google.cloud.dataflow.sdk.values.PValue;

class DisplayDataValidator {
    private DisplayDataValidator() {
    }

    static void validatePipeline(Pipeline pipeline) {
        DisplayDataValidator.validateOptions(pipeline);
        DisplayDataValidator.validateTransforms(pipeline);
    }

    private static void validateOptions(Pipeline pipeline) {
        DisplayDataValidator.evaluateDisplayData(pipeline.getOptions());
    }

    private static void validateTransforms(Pipeline pipeline) {
        pipeline.traverseTopologically(Visitor.INSTANCE);
    }

    private static void evaluateDisplayData(HasDisplayData component) {
        DisplayData.from(component);
    }

    private static class Visitor
    implements Pipeline.PipelineVisitor {
        private static final Visitor INSTANCE = new Visitor();

        private Visitor() {
        }

        @Override
        public void enterCompositeTransform(TransformTreeNode node) {
            if (!node.isRootNode()) {
                DisplayDataValidator.evaluateDisplayData(node.getTransform());
            }
        }

        @Override
        public void visitTransform(TransformTreeNode node) {
            DisplayDataValidator.evaluateDisplayData(node.getTransform());
        }

        @Override
        public void leaveCompositeTransform(TransformTreeNode node) {
        }

        @Override
        public void visitValue(PValue value, TransformTreeNode producer) {
        }
    }
}

