/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.dataflow;

import com.google.api.client.util.Base64;
import com.google.api.services.dataflow.model.SourceMetadata;
import com.google.cloud.dataflow.sdk.io.BoundedSource;
import com.google.cloud.dataflow.sdk.io.Source;
import com.google.cloud.dataflow.sdk.io.UnboundedSource;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSources {
    private static final String SERIALIZED_SOURCE = "serialized_source";
    @VisibleForTesting
    static final String SERIALIZED_SOURCE_SPLITS = "serialized_source_splits";
    public static final long DATAFLOW_SPLIT_RESPONSE_API_SIZE_BYTES = 0x1400000L;
    private static final Logger LOG = LoggerFactory.getLogger(CustomSources.class);
    private static final ByteString firstSplitKey = ByteString.copyFromUtf8((String)"0000000000000001");

    public static boolean isFirstUnboundedSourceSplit(ByteString splitKey) {
        return splitKey.equals((Object)firstSplitKey);
    }

    private static int getDesiredNumUnboundedSourceSplits(DataflowPipelineOptions options) {
        if (options.getMaxNumWorkers() > 0) {
            return options.getMaxNumWorkers();
        }
        if (options.getNumWorkers() > 0) {
            return options.getNumWorkers() * 3;
        }
        return 20;
    }

    public static com.google.api.services.dataflow.model.Source serializeToCloudSource(Source<?> source, PipelineOptions options) throws Exception {
        com.google.api.services.dataflow.model.Source cloudSource = new com.google.api.services.dataflow.model.Source();
        cloudSource.setSpec((Map)((Object)CloudObject.forClass(CustomSources.class)));
        Structs.addString(cloudSource.getSpec(), SERIALIZED_SOURCE, Base64.encodeBase64String((byte[])SerializableUtils.serializeToByteArray(source)));
        SourceMetadata metadata = new SourceMetadata();
        if (source instanceof BoundedSource) {
            BoundedSource boundedSource = (BoundedSource)source;
            try {
                metadata.setProducesSortedKeys(Boolean.valueOf(boundedSource.producesSortedKeys(options)));
            }
            catch (Exception e) {
                LOG.warn("Failed to check if the source produces sorted keys: " + source, (Throwable)e);
            }
            try {
                metadata.setEstimatedSizeBytes(Long.valueOf(boundedSource.getEstimatedSizeBytes(options)));
            }
            catch (Exception e) {
                LOG.warn("Size estimation of the source failed: " + source, (Throwable)e);
            }
        } else if (source instanceof UnboundedSource) {
            UnboundedSource unboundedSource = (UnboundedSource)source;
            metadata.setInfinite(Boolean.valueOf(true));
            ArrayList<String> encodedSplits = new ArrayList<String>();
            int desiredNumSplits = CustomSources.getDesiredNumUnboundedSourceSplits(options.as(DataflowPipelineOptions.class));
            for (UnboundedSource split : unboundedSource.generateInitialSplits(desiredNumSplits, options)) {
                encodedSplits.add(Base64.encodeBase64String((byte[])SerializableUtils.serializeToByteArray(split)));
            }
            Preconditions.checkArgument(!encodedSplits.isEmpty(), "UnboundedSources must have at least one split");
            Structs.addStringList(cloudSource.getSpec(), SERIALIZED_SOURCE_SPLITS, encodedSplits);
        } else {
            throw new IllegalArgumentException("Unexpected source kind: " + source.getClass());
        }
        cloudSource.setMetadata(metadata);
        return cloudSource;
    }
}

