/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.v1.ReadRowsResponse;
import com.google.bigtable.v1.Row;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.RowMerger;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.atomic.AtomicInteger;

public class ReadRowsResponseListener
extends ClientCall.Listener<ReadRowsResponse> {
    private final StreamObserver<Row> observer;
    private RowMerger builder;
    private AtomicInteger outstandingRequestCount;

    public ReadRowsResponseListener(StreamObserver<Row> observer, AtomicInteger outstandingRequestCount) {
        this.observer = observer;
        this.outstandingRequestCount = outstandingRequestCount;
    }

    public void onMessage(ReadRowsResponse response) {
        if (this.builder == null) {
            this.builder = new RowMerger();
        }
        this.builder.addPartialRow(response);
        this.outstandingRequestCount.decrementAndGet();
        if (this.builder.isRowCommitted()) {
            Row builtRow = this.builder.buildRow();
            this.builder = null;
            if (builtRow != null) {
                this.observer.onNext((Object)builtRow);
            }
        }
    }

    public void onClose(Status status, Metadata trailers) {
        if (status.isOk()) {
            if (this.builder != null) {
                this.observer.onError((Throwable)new IllegalStateException("End of stream marker encountered while merging a row."));
            } else {
                this.observer.onCompleted();
            }
        } else {
            this.observer.onError((Throwable)status.asRuntimeException());
        }
    }
}

