/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.v1.CheckAndMutateRowRequest;
import com.google.bigtable.v1.CheckAndMutateRowResponse;
import com.google.bigtable.v1.MutateRowRequest;
import com.google.bigtable.v1.MutateRowsRequest;
import com.google.bigtable.v1.MutateRowsResponse;
import com.google.bigtable.v1.ReadModifyWriteRowRequest;
import com.google.bigtable.v1.ReadRowsRequest;
import com.google.bigtable.v1.Row;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.RpcThrottler;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.Futures;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Empty;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.List;

public class AsyncExecutor {
    protected static final Logger LOG = new Logger(AsyncExecutor.class);
    protected static AsyncCall<MutateRowRequest, Empty> MUTATE_ROW_ASYNC = new AsyncCall<MutateRowRequest, Empty>(){

        @Override
        public ListenableFuture<Empty> call(BigtableDataClient client, MutateRowRequest request) {
            return client.mutateRowAsync(request);
        }
    };
    protected static AsyncCall<MutateRowsRequest, MutateRowsResponse> MUTATE_ROWS_ASYNC = new AsyncCall<MutateRowsRequest, MutateRowsResponse>(){

        @Override
        public ListenableFuture<MutateRowsResponse> call(BigtableDataClient client, MutateRowsRequest request) {
            return client.mutateRowsAsync(request);
        }
    };
    protected static AsyncCall<ReadModifyWriteRowRequest, Row> READ_MODIFY_WRITE_ASYNC = new AsyncCall<ReadModifyWriteRowRequest, Row>(){

        @Override
        public ListenableFuture<Row> call(BigtableDataClient client, ReadModifyWriteRowRequest request) {
            return client.readModifyWriteRowAsync(request);
        }
    };
    protected static AsyncCall<CheckAndMutateRowRequest, CheckAndMutateRowResponse> CHECK_AND_MUTATE_ASYNC = new AsyncCall<CheckAndMutateRowRequest, CheckAndMutateRowResponse>(){

        @Override
        public ListenableFuture<CheckAndMutateRowResponse> call(BigtableDataClient client, CheckAndMutateRowRequest request) {
            return client.checkAndMutateRowAsync(request);
        }
    };
    protected static AsyncCall<ReadRowsRequest, List<Row>> READ_ROWS_ASYNC = new AsyncCall<ReadRowsRequest, List<Row>>(){

        @Override
        public ListenableFuture<List<Row>> call(BigtableDataClient client, ReadRowsRequest request) {
            return client.readRowsAsync(request);
        }
    };
    private final BigtableDataClient client;
    private final RpcThrottler rpcThrottler;

    public AsyncExecutor(BigtableDataClient client, RpcThrottler rpcThrottler) {
        this.client = client;
        this.rpcThrottler = rpcThrottler;
    }

    public ListenableFuture<Empty> mutateRowAsync(MutateRowRequest request, long operationId) {
        return this.call(MUTATE_ROW_ASYNC, request, operationId);
    }

    public ListenableFuture<MutateRowsResponse> mutateRowAsync(MutateRowsRequest request, long operationId) {
        return this.call(MUTATE_ROWS_ASYNC, request, operationId);
    }

    public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRowAsync(CheckAndMutateRowRequest request, long operationId) {
        return this.call(CHECK_AND_MUTATE_ASYNC, request, operationId);
    }

    public ListenableFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRowRequest request, long operationId) {
        return this.call(READ_MODIFY_WRITE_ASYNC, request, operationId);
    }

    public ListenableFuture<List<Row>> readRowsAsync(ReadRowsRequest request, long operationId) {
        return this.call(READ_ROWS_ASYNC, request, operationId);
    }

    public ListenableFuture<Empty> mutateRowAsync(MutateRowRequest request) throws InterruptedException {
        return this.call(MUTATE_ROW_ASYNC, request);
    }

    public ListenableFuture<MutateRowsResponse> mutateRowsAsync(MutateRowsRequest request) throws InterruptedException {
        return this.call(MUTATE_ROWS_ASYNC, request);
    }

    public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRowAsync(CheckAndMutateRowRequest request) throws InterruptedException {
        return this.call(CHECK_AND_MUTATE_ASYNC, request);
    }

    public ListenableFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRowRequest request) throws InterruptedException {
        return this.call(READ_MODIFY_WRITE_ASYNC, request);
    }

    public ListenableFuture<List<Row>> readRowsAsync(ReadRowsRequest request) throws InterruptedException {
        return this.call(READ_ROWS_ASYNC, request);
    }

    private <RequestT extends GeneratedMessage, ResponseT> ListenableFuture<ResponseT> call(AsyncCall<RequestT, ResponseT> rpc, RequestT request) throws InterruptedException {
        long id = this.rpcThrottler.registerOperationWithHeapSize(request.getSerializedSize());
        return this.call(rpc, request, id);
    }

    private <ResponseT, RequestT extends GeneratedMessage> ListenableFuture<ResponseT> call(AsyncCall<RequestT, ResponseT> rpc, RequestT request, long id) {
        ListenableFuture<Object> future;
        try {
            future = rpc.call(this.client, request);
        }
        catch (Exception e) {
            future = Futures.immediateFailedFuture(e);
        }
        this.rpcThrottler.addCallback(future, id);
        return future;
    }

    public void flush() throws IOException {
        LOG.trace("Flushing", new Object[0]);
        try {
            this.rpcThrottler.awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Batch operations were interrupted.");
        }
        LOG.trace("Done flushing", new Object[0]);
    }

    public boolean hasInflightRequests() {
        return this.rpcThrottler.hasInflightRequests();
    }

    public long getMaxHeapSize() {
        return this.rpcThrottler.getMaxHeapSize();
    }

    public BigtableDataClient getClient() {
        return this.client;
    }

    public RpcThrottler getRpcThrottler() {
        return this.rpcThrottler;
    }

    protected static interface AsyncCall<RequestT, ResponseT> {
        public ListenableFuture<ResponseT> call(BigtableDataClient var1, RequestT var2);
    }
}

