/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.google.cloud.dataflow.sdk.options.Hidden;
import com.google.cloud.dataflow.sdk.options.PipelineOptionSpec;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.HashMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Multimap;
import com.google.cloud.dataflow.sdk.util.common.ReflectHelpers;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;

class PipelineOptionsReflector {
    private PipelineOptionsReflector() {
    }

    static Set<PipelineOptionSpec> getOptionSpecs(Class<? extends PipelineOptions> optionsInterface) {
        Iterable<Method> methods = ReflectHelpers.getClosureOfMethodsOnInterface(optionsInterface);
        Multimap<String, Method> propsToGetters = PipelineOptionsReflector.getPropertyNamesToGetters(methods);
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (Map.Entry<String, Method> propAndGetter : propsToGetters.entries()) {
            String prop = propAndGetter.getKey();
            Method getter = propAndGetter.getValue();
            Class<?> declaringClass = getter.getDeclaringClass();
            if (!PipelineOptions.class.isAssignableFrom(declaringClass) || declaringClass.isAnnotationPresent(Hidden.class)) continue;
            setBuilder.add(PipelineOptionSpec.of(declaringClass, prop, getter));
        }
        return setBuilder.build();
    }

    static Set<PipelineOptionSpec> getOptionSpecs(Iterable<Class<? extends PipelineOptions>> optionsInterfaces) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (Class<? extends PipelineOptions> optionsInterface : optionsInterfaces) {
            setBuilder.addAll(PipelineOptionsReflector.getOptionSpecs(optionsInterface));
        }
        return setBuilder.build();
    }

    static Multimap<String, Method> getPropertyNamesToGetters(Iterable<Method> methods) {
        HashMultimap<String, Method> propertyNamesToGetters = HashMultimap.create();
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") && !methodName.startsWith("is") || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            String propertyName = Introspector.decapitalize(methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3));
            propertyNamesToGetters.put(propertyName, method);
        }
        return propertyNamesToGetters;
    }
}

