/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.ProxyInvocationHandler;
import com.google.cloud.dataflow.sdk.options.Validation;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.PipelineRunner;
import com.google.cloud.dataflow.sdk.transforms.display.HasDisplayData;
import javax.annotation.concurrent.ThreadSafe;

@JsonSerialize(using=ProxyInvocationHandler.Serializer.class)
@JsonDeserialize(using=ProxyInvocationHandler.Deserializer.class)
@ThreadSafe
public interface PipelineOptions
extends HasDisplayData {
    public <T extends PipelineOptions> T as(Class<T> var1);

    public <T extends PipelineOptions> T cloneAs(Class<T> var1);

    @Validation.Required
    @Description(value="The pipeline runner that will be used to execute the pipeline. For registered runners, the class name can be specified, otherwise the fully qualified name needs to be specified.")
    @Default.Class(value=DirectPipelineRunner.class)
    public Class<? extends PipelineRunner<?>> getRunner();

    public void setRunner(Class<? extends PipelineRunner<?>> var1);

    @Validation.Required
    @Description(value="Whether to check for stable unique names on each transform. This is necessary to support updating of pipelines.")
    @Default.Enum(value="WARNING")
    public CheckEnabled getStableUniqueNames();

    public void setStableUniqueNames(CheckEnabled var1);

    @Description(value="A pipeline level default location for storing temporary files.")
    public String getTempLocation();

    public void setTempLocation(String var1);

    public static enum CheckEnabled {
        OFF,
        WARNING,
        ERROR;

    }
}

