/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io.range;

import com.google.cloud.dataflow.sdk.io.range.ByteKey;
import com.google.cloud.dataflow.sdk.io.range.ByteKeyRange;
import com.google.cloud.dataflow.sdk.io.range.RangeTracker;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteKeyRangeTracker
implements RangeTracker<ByteKey> {
    private static final Logger logger = LoggerFactory.getLogger(ByteKeyRangeTracker.class);
    private ByteKeyRange range;
    @Nullable
    private ByteKey position;
    private long splitPointsSeen;
    private boolean done;

    public static ByteKeyRangeTracker of(ByteKeyRange range) {
        return new ByteKeyRangeTracker(range);
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized ByteKey getStartPosition() {
        return this.range.getStartKey();
    }

    @Override
    public synchronized ByteKey getStopPosition() {
        return this.range.getEndKey();
    }

    public synchronized ByteKeyRange getRange() {
        return this.range;
    }

    @Override
    public synchronized boolean tryReturnRecordAt(boolean isAtSplitPoint, ByteKey recordStart) {
        if (this.done) {
            return false;
        }
        Preconditions.checkState(this.position != null || isAtSplitPoint, "The first record must be at a split point");
        Preconditions.checkState(recordStart.compareTo(this.range.getStartKey()) >= 0, "Trying to return record which is before the start key");
        Preconditions.checkState(this.position == null || recordStart.compareTo(this.position) >= 0, "Trying to return record which is before the last-returned record");
        if (this.position == null) {
            this.range = this.range.withStartKey(recordStart);
        }
        this.position = recordStart;
        if (isAtSplitPoint) {
            if (!this.range.containsKey(recordStart).booleanValue()) {
                this.done = true;
                return false;
            }
            ++this.splitPointsSeen;
        }
        return true;
    }

    @Override
    public synchronized boolean trySplitAtPosition(ByteKey splitPosition) {
        if (this.position == null) {
            logger.warn("{}: Rejecting split request at {} because no records have been returned.", (Object)this, (Object)splitPosition);
            return false;
        }
        if (splitPosition.compareTo(this.position) <= 0) {
            logger.warn("{}: Rejecting split request at {} because it is not after current position {}.", new Object[]{this, splitPosition, this.position});
            return false;
        }
        if (!this.range.containsKey(splitPosition).booleanValue()) {
            logger.warn("{}: Rejecting split request at {} because it is not within the range.", (Object)this, (Object)splitPosition);
            return false;
        }
        this.range = this.range.withEndKey(splitPosition);
        return true;
    }

    @Override
    public synchronized double getFractionConsumed() {
        if (this.position == null) {
            return 0.0;
        }
        return this.range.estimateFractionForKey(this.position);
    }

    public synchronized long getSplitPointsConsumed() {
        if (this.position == null) {
            return 0L;
        }
        if (this.isDone()) {
            return this.splitPointsSeen;
        }
        Preconditions.checkState(this.splitPointsSeen > 0L, "A started rangeTracker should have seen > 0 split points (is %s)", this.splitPointsSeen);
        return this.splitPointsSeen - 1L;
    }

    private ByteKeyRangeTracker(ByteKeyRange range) {
        this.range = range;
        this.position = null;
        this.splitPointsSeen = 0L;
        this.done = false;
    }

    public synchronized boolean markDone() {
        this.done = true;
        return false;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper(ByteKeyRangeTracker.class).add("range", this.range).add("position", this.position).toString();
    }
}

