/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.SerializableCoder;
import com.google.cloud.dataflow.sdk.io.Sink;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.util.FileIOChannelFactory;
import com.google.cloud.dataflow.sdk.util.GcsIOChannelFactory;
import com.google.cloud.dataflow.sdk.util.GcsUtil;
import com.google.cloud.dataflow.sdk.util.IOChannelFactory;
import com.google.cloud.dataflow.sdk.util.IOChannelUtils;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileBasedSink<T>
extends Sink<T> {
    protected final String baseOutputFilename;
    protected final String extension;
    protected final String fileNamingTemplate;

    public FileBasedSink(String baseOutputFilename, String extension) {
        this(baseOutputFilename, extension, "-SSSSS-of-NNNNN");
    }

    public FileBasedSink(String baseOutputFilename, String extension, String fileNamingTemplate) {
        this.baseOutputFilename = baseOutputFilename;
        this.extension = extension;
        this.fileNamingTemplate = fileNamingTemplate;
    }

    public String getBaseOutputFilename() {
        return this.baseOutputFilename;
    }

    @Override
    public void validate(PipelineOptions options) {
    }

    public abstract FileBasedWriteOperation<T> createWriteOperation(PipelineOptions var1);

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        String fileNamePattern = String.format("%s%s%s", this.baseOutputFilename, this.fileNamingTemplate, FileBasedSink.getFileExtension(this.extension));
        builder.add(DisplayData.item("fileNamePattern", fileNamePattern).withLabel("File Name Pattern"));
    }

    private static String getFileExtension(String usersExtension) {
        if (usersExtension == null || usersExtension.isEmpty()) {
            return "";
        }
        if (usersExtension.startsWith(".")) {
            return usersExtension;
        }
        return "." + usersExtension;
    }

    private static class LocalFileOperations
    implements FileOperations {
        private static final Logger LOG = LoggerFactory.getLogger(LocalFileOperations.class);

        private LocalFileOperations() {
        }

        @Override
        public void copy(List<String> srcFilenames, List<String> destFilenames) throws IOException {
            Preconditions.checkArgument(srcFilenames.size() == destFilenames.size(), "Number of source files %s must equal number of destination files %s", srcFilenames.size(), destFilenames.size());
            int numFiles = srcFilenames.size();
            for (int i = 0; i < numFiles; ++i) {
                String src = srcFilenames.get(i);
                String dst = destFilenames.get(i);
                LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
                this.copyOne(src, dst);
            }
        }

        private void copyOne(String source, String destination) throws IOException {
            try {
                Files.copy(Paths.get(source, new String[0]), Paths.get(destination, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (NoSuchFileException e) {
                LOG.debug("{} does not exist.", (Object)source);
            }
        }

        @Override
        public void remove(Collection<String> filenames) throws IOException {
            for (String filename : filenames) {
                LOG.debug("Removing file {}", (Object)filename);
                this.removeOne(filename);
            }
        }

        private void removeOne(String filename) throws IOException {
            boolean exists = Files.deleteIfExists(Paths.get(filename, new String[0]));
            if (!exists) {
                LOG.debug("{} does not exist.", (Object)filename);
            }
        }
    }

    private static class GcsOperations
    implements FileOperations {
        private final GcsUtil gcsUtil;

        public GcsOperations(PipelineOptions options) {
            this.gcsUtil = new GcsUtil.GcsUtilFactory().create(options);
        }

        @Override
        public void copy(List<String> srcFilenames, List<String> destFilenames) throws IOException {
            this.gcsUtil.copy(srcFilenames, destFilenames);
        }

        @Override
        public void remove(Collection<String> filenames) throws IOException {
            this.gcsUtil.remove(filenames);
        }
    }

    private static interface FileOperations {
        public void copy(List<String> var1, List<String> var2) throws IOException;

        public void remove(Collection<String> var1) throws IOException;
    }

    private static class FileOperationsFactory {
        private FileOperationsFactory() {
        }

        public static FileOperations getFileOperations(String spec, PipelineOptions options) throws IOException {
            IOChannelFactory factory = IOChannelUtils.getFactory(spec);
            if (factory instanceof GcsIOChannelFactory) {
                return new GcsOperations(options);
            }
            if (factory instanceof FileIOChannelFactory) {
                return new LocalFileOperations();
            }
            throw new IOException("Unrecognized file system.");
        }
    }

    public static final class FileResult
    implements Serializable {
        private final String filename;

        public FileResult(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    public static abstract class FileBasedWriter<T>
    extends Sink.Writer<T, FileResult> {
        private static final Logger LOG = LoggerFactory.getLogger(FileBasedWriter.class);
        final FileBasedWriteOperation<T> writeOperation;
        private String id;
        private String filename;
        private WritableByteChannel channel;
        protected String mimeType = "text/plain";

        public FileBasedWriter(FileBasedWriteOperation<T> writeOperation) {
            Preconditions.checkNotNull(writeOperation);
            this.writeOperation = writeOperation;
        }

        protected abstract void prepareWrite(WritableByteChannel var1) throws Exception;

        protected void writeHeader() throws Exception {
        }

        protected void writeFooter() throws Exception {
        }

        @Override
        public final void open(String uId) throws Exception {
            this.id = uId;
            this.filename = FileBasedWriteOperation.buildTemporaryFilename(((FileBasedWriteOperation)this.getWriteOperation()).baseTemporaryFilename, uId);
            LOG.debug("Opening {}.", (Object)this.filename);
            this.channel = IOChannelUtils.create(this.filename, this.mimeType);
            try {
                this.prepareWrite(this.channel);
                LOG.debug("Writing header to {}.", (Object)this.filename);
                this.writeHeader();
            }
            catch (Exception e) {
                try {
                    LOG.error("Writing header to {} failed, closing channel.", (Object)this.filename);
                    this.channel.close();
                }
                catch (IOException closeException) {
                    LOG.error("Closing channel for {} failed: {}", (Object)this.filename, (Object)closeException.getMessage());
                }
                throw e;
            }
            LOG.debug("Starting write of bundle {} to {}.", (Object)this.id, (Object)this.filename);
        }

        @Override
        public final FileResult close() throws Exception {
            try (WritableByteChannel theChannel = this.channel;){
                LOG.debug("Writing footer to {}.", (Object)this.filename);
                this.writeFooter();
            }
            FileResult result = new FileResult(this.filename);
            LOG.debug("Result for bundle {}: {}", (Object)this.id, (Object)this.filename);
            return result;
        }

        public FileBasedWriteOperation<T> getWriteOperation() {
            return this.writeOperation;
        }
    }

    public static abstract class FileBasedWriteOperation<T>
    extends Sink.WriteOperation<T, FileResult> {
        private static final Logger LOG = LoggerFactory.getLogger(FileBasedWriteOperation.class);
        protected final FileBasedSink<T> sink;
        protected final TemporaryFileRetention temporaryFileRetention;
        protected final String baseTemporaryFilename;
        protected static final String TEMPORARY_FILENAME_SEPARATOR = "-temp-";

        protected static final String buildTemporaryFilename(String prefix, String suffix) {
            return prefix + TEMPORARY_FILENAME_SEPARATOR + suffix;
        }

        public FileBasedWriteOperation(FileBasedSink<T> sink) {
            this(sink, sink.baseOutputFilename);
        }

        public FileBasedWriteOperation(FileBasedSink<T> sink, String baseTemporaryFilename) {
            this(sink, baseTemporaryFilename, TemporaryFileRetention.REMOVE);
        }

        public FileBasedWriteOperation(FileBasedSink<T> sink, String baseTemporaryFilename, TemporaryFileRetention temporaryFileRetention) {
            this.sink = sink;
            this.baseTemporaryFilename = baseTemporaryFilename;
            this.temporaryFileRetention = temporaryFileRetention;
        }

        public abstract FileBasedWriter<T> createWriter(PipelineOptions var1) throws Exception;

        @Override
        public void initialize(PipelineOptions options) throws Exception {
        }

        @Override
        public void finalize(Iterable<FileResult> writerResults, PipelineOptions options) throws Exception {
            ArrayList<String> files = new ArrayList<String>();
            for (FileResult result : writerResults) {
                LOG.debug("Temporary bundle output file {} will be copied.", (Object)result.getFilename());
                files.add(result.getFilename());
            }
            this.copyToOutputFiles(files, options);
            if (this.temporaryFileRetention == TemporaryFileRetention.REMOVE) {
                this.removeTemporaryFiles(options);
            }
        }

        protected final List<String> copyToOutputFiles(List<String> filenames, PipelineOptions options) throws IOException {
            int numFiles = filenames.size();
            ArrayList<String> srcFilenames = new ArrayList<String>();
            List<String> destFilenames = this.generateDestinationFilenames(numFiles);
            srcFilenames.addAll(filenames);
            Collections.sort(srcFilenames);
            if (numFiles > 0) {
                LOG.debug("Copying {} files.", (Object)numFiles);
                FileOperations fileOperations = FileOperationsFactory.getFileOperations(destFilenames.get(0), options);
                fileOperations.copy(srcFilenames, destFilenames);
            } else {
                LOG.info("No output files to write.");
            }
            return destFilenames;
        }

        protected final List<String> generateDestinationFilenames(int numFiles) {
            ArrayList<String> destFilenames = new ArrayList<String>();
            String extension = ((FileBasedSink)this.getSink()).extension;
            String baseOutputFilename = ((FileBasedSink)this.getSink()).baseOutputFilename;
            String fileNamingTemplate = ((FileBasedSink)this.getSink()).fileNamingTemplate;
            String suffix = FileBasedSink.getFileExtension(extension);
            for (int i = 0; i < numFiles; ++i) {
                destFilenames.add(IOChannelUtils.constructName(baseOutputFilename, fileNamingTemplate, suffix, i, numFiles));
            }
            return destFilenames;
        }

        protected final void removeTemporaryFiles(PipelineOptions options) throws IOException {
            String pattern = FileBasedWriteOperation.buildTemporaryFilename(this.baseTemporaryFilename, "*");
            LOG.debug("Finding temporary bundle output files matching {}.", (Object)pattern);
            FileOperations fileOperations = FileOperationsFactory.getFileOperations(pattern, options);
            IOChannelFactory factory = IOChannelUtils.getFactory(pattern);
            Collection<String> matches = factory.match(pattern);
            LOG.debug("{} temporary files matched {}", (Object)matches.size(), (Object)pattern);
            LOG.debug("Removing {} files.", (Object)matches.size());
            fileOperations.remove(matches);
        }

        @Override
        public Coder<FileResult> getWriterResultCoder() {
            return SerializableCoder.of(FileResult.class);
        }

        @Override
        public FileBasedSink<T> getSink() {
            return this.sink;
        }

        public static enum TemporaryFileRetention {
            KEEP,
            REMOVE;

        }
    }
}

