/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.io.CountingSource;
import com.google.cloud.dataflow.sdk.io.Read;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.values.PBegin;
import com.google.cloud.dataflow.sdk.values.PCollection;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class CountingInput {
    public static BoundedCountingInput upTo(long numElements) {
        Preconditions.checkArgument(numElements > 0L, "numElements (%s) must be greater than 0", numElements);
        return new BoundedCountingInput(numElements);
    }

    public static UnboundedCountingInput unbounded() {
        return new UnboundedCountingInput(new CountingSource.NowTimestampFn(), 1L, Duration.ZERO, Optional.absent(), Optional.absent());
    }

    public static class UnboundedCountingInput
    extends PTransform<PBegin, PCollection<Long>> {
        private final SerializableFunction<Long, Instant> timestampFn;
        private final long elementsPerPeriod;
        private final Duration period;
        private final Optional<Long> maxNumRecords;
        private final Optional<Duration> maxReadTime;

        private UnboundedCountingInput(SerializableFunction<Long, Instant> timestampFn, long elementsPerPeriod, Duration period, Optional<Long> maxNumRecords, Optional<Duration> maxReadTime) {
            this.timestampFn = timestampFn;
            this.elementsPerPeriod = elementsPerPeriod;
            this.period = period;
            this.maxNumRecords = maxNumRecords;
            this.maxReadTime = maxReadTime;
        }

        public UnboundedCountingInput withTimestampFn(SerializableFunction<Long, Instant> timestampFn) {
            return new UnboundedCountingInput(timestampFn, this.elementsPerPeriod, this.period, this.maxNumRecords, this.maxReadTime);
        }

        public UnboundedCountingInput withMaxNumRecords(long maxRecords) {
            Preconditions.checkArgument(maxRecords > 0L, "MaxRecords must be a positive (nonzero) value. Got %s", maxRecords);
            return new UnboundedCountingInput(this.timestampFn, this.elementsPerPeriod, this.period, Optional.of(maxRecords), this.maxReadTime);
        }

        public UnboundedCountingInput withRate(long numElements, Duration periodLength) {
            return new UnboundedCountingInput(this.timestampFn, numElements, periodLength, this.maxNumRecords, this.maxReadTime);
        }

        public UnboundedCountingInput withMaxReadTime(Duration readTime) {
            Preconditions.checkNotNull(readTime, "ReadTime cannot be null");
            return new UnboundedCountingInput(this.timestampFn, this.elementsPerPeriod, this.period, this.maxNumRecords, Optional.of(readTime));
        }

        @Override
        public PCollection<Long> apply(PBegin begin) {
            Read.Unbounded<Long> read = Read.from(CountingSource.createUnbounded().withTimestampFn(this.timestampFn).withRate(this.elementsPerPeriod, this.period));
            if (!this.maxNumRecords.isPresent() && !this.maxReadTime.isPresent()) {
                return (PCollection)begin.apply(read);
            }
            if (this.maxNumRecords.isPresent() && !this.maxReadTime.isPresent()) {
                return (PCollection)begin.apply(read.withMaxNumRecords(this.maxNumRecords.get()));
            }
            if (!this.maxNumRecords.isPresent() && this.maxReadTime.isPresent()) {
                return (PCollection)begin.apply(read.withMaxReadTime(this.maxReadTime.get()));
            }
            return (PCollection)begin.apply(read.withMaxReadTime(this.maxReadTime.get()).withMaxNumRecords(this.maxNumRecords.get()));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("timestampFn", this.timestampFn.getClass()).withLabel("Timestamp Function"));
            if (this.maxReadTime.isPresent()) {
                builder.add(DisplayData.item("maxReadTime", this.maxReadTime.get()).withLabel("Maximum Read Time"));
            }
            if (this.maxNumRecords.isPresent()) {
                builder.add(DisplayData.item("maxRecords", this.maxNumRecords.get()).withLabel("Maximum Read Records"));
            }
        }
    }

    public static class BoundedCountingInput
    extends PTransform<PBegin, PCollection<Long>> {
        private final long numElements;

        private BoundedCountingInput(long numElements) {
            this.numElements = numElements;
        }

        @Override
        public PCollection<Long> apply(PBegin begin) {
            return (PCollection)begin.apply(Read.from(CountingSource.upTo(this.numElements)));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("upTo", this.numElements).withLabel("Count Up To"));
        }
    }
}

