/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders.protobuf;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.protobuf.ProtoCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;

class ProtobufUtil {
    static Descriptors.Descriptor getDescriptorForClass(Class<? extends Message> clazz) {
        try {
            return (Descriptors.Descriptor)clazz.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static Set<Descriptors.Descriptor> getRecursiveDescriptorsForClass(Class<? extends Message> clazz, ExtensionRegistry registry) {
        Descriptors.Descriptor root = ProtobufUtil.getDescriptorForClass(clazz);
        HashSet<Descriptors.Descriptor> descriptors = new HashSet<Descriptors.Descriptor>();
        ProtobufUtil.recursivelyAddDescriptors(root, descriptors, registry);
        return descriptors;
    }

    static void checkProto2Syntax(Class<? extends Message> clazz, ExtensionRegistry registry) {
        for (Descriptors.GenericDescriptor genericDescriptor : ProtobufUtil.getRecursiveDescriptorsForClass(clazz, registry)) {
            Descriptors.FileDescriptor.Syntax s = genericDescriptor.getFile().getSyntax();
            Preconditions.checkArgument(s == Descriptors.FileDescriptor.Syntax.PROTO2, "Message %s or one of its dependencies does not use proto2 syntax: %s in file %s", clazz.getName(), genericDescriptor.getFullName(), genericDescriptor.getFile().getName());
        }
    }

    static void verifyDeterministic(ProtoCoder<?> coder) throws Coder.NonDeterministicException {
        Class<?> message = coder.getMessageType();
        ExtensionRegistry registry = coder.getExtensionRegistry();
        Set<Descriptors.Descriptor> descriptors = ProtobufUtil.getRecursiveDescriptorsForClass(message, registry);
        for (Descriptors.Descriptor d : descriptors) {
            for (Descriptors.FieldDescriptor fd : d.getFields()) {
                if (!fd.isMapField()) continue;
                String reason = String.format("Protocol Buffers message %s transitively includes Map field %s (from file %s). Maps cannot be deterministically encoded.", message.getName(), fd.getFullName(), fd.getFile().getFullName());
                throw new Coder.NonDeterministicException(coder, reason);
            }
        }
    }

    private ProtobufUtil() {
    }

    private static void recursivelyAddDescriptors(Descriptors.Descriptor message, Set<Descriptors.Descriptor> descriptors, ExtensionRegistry registry) {
        if (descriptors.contains(message)) {
            return;
        }
        descriptors.add(message);
        for (Descriptors.FieldDescriptor f : message.getFields()) {
            ProtobufUtil.recursivelyAddDescriptors(f, descriptors, registry);
        }
        for (Descriptors.FieldDescriptor f : message.getExtensions()) {
            ProtobufUtil.recursivelyAddDescriptors(f, descriptors, registry);
        }
        for (ExtensionRegistry.ExtensionInfo info : registry.getAllImmutableExtensionsByExtendedType(message.getFullName())) {
            ProtobufUtil.recursivelyAddDescriptors(info.descriptor, descriptors, registry);
        }
        for (ExtensionRegistry.ExtensionInfo info : registry.getAllMutableExtensionsByExtendedType(message.getFullName())) {
            ProtobufUtil.recursivelyAddDescriptors(info.descriptor, descriptors, registry);
        }
    }

    private static void recursivelyAddDescriptors(Descriptors.FieldDescriptor field, Set<Descriptors.Descriptor> descriptors, ExtensionRegistry registry) {
        switch (field.getType()) {
            case BOOL: 
            case BYTES: 
            case DOUBLE: 
            case ENUM: 
            case FIXED32: 
            case FIXED64: 
            case FLOAT: 
            case INT32: 
            case INT64: 
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: 
            case STRING: 
            case UINT32: 
            case UINT64: {
                break;
            }
            case GROUP: 
            case MESSAGE: {
                ProtobufUtil.recursivelyAddDescriptors(field.getMessageType(), descriptors, registry);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected Protocol Buffers field type: " + field.getType());
            }
        }
    }
}

