/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders.protobuf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.CoderProvider;
import com.google.cloud.dataflow.sdk.coders.protobuf.ProtobufUtil;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Sets;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class ProtoCoder<T extends Message>
extends AtomicCoder<T> {
    private final Class<T> protoMessageClass;
    private final Set<Class<?>> extensionHostClasses;
    private static final String PROTO_MESSAGE_CLASS = "proto_message_class";
    private static final String PROTO_EXTENSION_HOSTS = "proto_extension_hosts";
    private transient ExtensionRegistry memoizedExtensionRegistry;
    private transient Parser<T> memoizedParser;
    private static final CoderProvider PROVIDER = new CoderProvider(){

        @Override
        public <T> Coder<T> getCoder(TypeDescriptor<T> type) throws CannotProvideCoderException {
            if (!type.isSubtypeOf(new TypeDescriptor<Message>(){})) {
                throw new CannotProvideCoderException(String.format("Cannot provide %s because %s is not a subclass of %s", ProtoCoder.class.getSimpleName(), type, Message.class.getName()));
            }
            TypeDescriptor<T> messageType = type;
            try {
                ProtoCoder<T> coder = ProtoCoder.of(messageType);
                return coder;
            }
            catch (IllegalArgumentException e) {
                throw new CannotProvideCoderException(e);
            }
        }
    };

    public static CoderProvider coderProvider() {
        return PROVIDER;
    }

    public static <T extends Message> ProtoCoder<T> of(Class<T> protoMessageClass) {
        return new ProtoCoder<T>(protoMessageClass, ImmutableSet.of());
    }

    public static <T extends Message> ProtoCoder<T> of(TypeDescriptor<T> protoMessageType) {
        Class<T> protoMessageClass = protoMessageType.getRawType();
        return ProtoCoder.of(protoMessageClass);
    }

    public ProtoCoder<T> withExtensionsFrom(Iterable<Class<?>> moreExtensionHosts) {
        for (Class<?> extensionHost : moreExtensionHosts) {
            try {
                Method registerAllExtensions = extensionHost.getDeclaredMethod("registerAllExtensions", ExtensionRegistry.class);
                Preconditions.checkArgument(Modifier.isStatic(registerAllExtensions.getModifiers()), "Method registerAllExtensions() must be static");
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException(String.format("Unable to register extensions for %s", extensionHost.getCanonicalName()), e);
            }
        }
        return new ProtoCoder<T>(this.protoMessageClass, (Set<Class<?>>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll(this.extensionHostClasses)).addAll(moreExtensionHosts)).build()));
    }

    public ProtoCoder<T> withExtensionsFrom(Class<?> ... moreExtensionHosts) {
        return this.withExtensionsFrom(Arrays.asList(moreExtensionHosts));
    }

    @Override
    public void encode(T value, OutputStream outStream, Coder.Context context) throws IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null " + this.protoMessageClass.getSimpleName());
        }
        if (context.isWholeStream) {
            value.writeTo(outStream);
        } else {
            value.writeDelimitedTo(outStream);
        }
    }

    @Override
    public T decode(InputStream inStream, Coder.Context context) throws IOException {
        if (context.isWholeStream) {
            return (T)((Message)this.getParser().parseFrom(inStream, (ExtensionRegistryLite)this.getExtensionRegistry()));
        }
        return (T)((Message)this.getParser().parseDelimitedFrom(inStream, (ExtensionRegistryLite)this.getExtensionRegistry()));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProtoCoder)) {
            return false;
        }
        ProtoCoder otherCoder = (ProtoCoder)other;
        return this.protoMessageClass.equals(otherCoder.protoMessageClass) && Sets.newHashSet(this.extensionHostClasses).equals(Sets.newHashSet(otherCoder.extensionHostClasses));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.protoMessageClass, this.extensionHostClasses);
    }

    @Override
    public String getEncodingId() {
        return this.protoMessageClass.getName() + this.getSortedExtensionClasses().toString();
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        ProtobufUtil.verifyDeterministic(this);
    }

    public Class<T> getMessageType() {
        return this.protoMessageClass;
    }

    public ExtensionRegistry getExtensionRegistry() {
        if (this.memoizedExtensionRegistry == null) {
            ExtensionRegistry registry = ExtensionRegistry.newInstance();
            for (Class<?> extensionHost : this.extensionHostClasses) {
                try {
                    extensionHost.getDeclaredMethod("registerAllExtensions", ExtensionRegistry.class).invoke(null, registry);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.memoizedExtensionRegistry = registry.getUnmodifiable();
        }
        return this.memoizedExtensionRegistry;
    }

    private ProtoCoder(Class<T> protoMessageClass, Set<Class<?>> extensionHostClasses) {
        this.protoMessageClass = protoMessageClass;
        this.extensionHostClasses = extensionHostClasses;
    }

    @JsonCreator
    @Deprecated
    public static <T extends Message> ProtoCoder<T> of(@JsonProperty(value="proto_message_class") String protoMessageClassName, @Nullable @JsonProperty(value="proto_extension_hosts") List<String> extensionHostClassNames) {
        try {
            Class<?> protoMessageClass = Class.forName(protoMessageClassName);
            ArrayList<Class<?>> extensionHostClasses = Lists.newArrayList();
            if (extensionHostClassNames != null) {
                for (String extensionHostClassName : extensionHostClassNames) {
                    extensionHostClasses.add(Class.forName(extensionHostClassName));
                }
            }
            return ProtoCoder.of(protoMessageClass).withExtensionsFrom(extensionHostClasses);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public CloudObject asCloudObject() {
        CloudObject result = super.asCloudObject();
        Structs.addString((Map<String, Object>)((Object)result), PROTO_MESSAGE_CLASS, this.protoMessageClass.getName());
        ArrayList<CloudObject> extensionHostClassNames = Lists.newArrayList();
        for (String className : this.getSortedExtensionClasses()) {
            extensionHostClassNames.add(CloudObject.forString(className));
        }
        Structs.addList((Map<String, Object>)((Object)result), PROTO_EXTENSION_HOSTS, extensionHostClassNames);
        return result;
    }

    private Parser<T> getParser() {
        if (this.memoizedParser == null) {
            try {
                Parser tParser;
                Message protoMessageInstance = (Message)this.protoMessageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
                this.memoizedParser = tParser = protoMessageInstance.getParserForType();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.memoizedParser;
    }

    private SortedSet<String> getSortedExtensionClasses() {
        TreeSet<String> ret = new TreeSet<String>();
        for (Class<?> clazz : this.extensionHostClasses) {
            ret.add(clazz.getName());
        }
        return ret;
    }
}

