/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.util.VarInt;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class VarIntCoder
extends AtomicCoder<Integer> {
    private static final VarIntCoder INSTANCE = new VarIntCoder();

    @JsonCreator
    public static VarIntCoder of() {
        return INSTANCE;
    }

    private VarIntCoder() {
    }

    @Override
    public void encode(Integer value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        VarInt.encode(value, outStream);
    }

    @Override
    public Integer decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        try {
            return VarInt.decodeInt(inStream);
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Integer value, Coder.Context context) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(Integer value, Coder.Context context) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        return VarInt.getLength(value.longValue());
    }
}

