/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.StringUtf8Coder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TableRowJsonCoder
extends AtomicCoder<TableRow> {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private static final TableRowJsonCoder INSTANCE = new TableRowJsonCoder();

    @JsonCreator
    public static TableRowJsonCoder of() {
        return INSTANCE;
    }

    @Override
    public void encode(TableRow value, OutputStream outStream, Coder.Context context) throws IOException {
        String strValue = MAPPER.writeValueAsString((Object)value);
        StringUtf8Coder.of().encode(strValue, outStream, context);
    }

    @Override
    public TableRow decode(InputStream inStream, Coder.Context context) throws IOException {
        String strValue = StringUtf8Coder.of().decode(inStream, context);
        return (TableRow)MAPPER.readValue(strValue, TableRow.class);
    }

    @Override
    protected long getEncodedElementByteSize(TableRow value, Coder.Context context) throws Exception {
        String strValue = MAPPER.writeValueAsString((Object)value);
        return StringUtf8Coder.of().getEncodedElementByteSize(strValue, context);
    }

    private TableRowJsonCoder() {
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "TableCell can hold arbitrary instances, which may be non-deterministic.");
    }
}

