/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.MapCoderBase;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapCoder<K, V>
extends MapCoderBase<Map<K, V>> {
    Coder<K> keyCoder;
    Coder<V> valueCoder;

    public static <K, V> MapCoder<K, V> of(Coder<K> keyCoder, Coder<V> valueCoder) {
        return new MapCoder<K, V>(keyCoder, valueCoder);
    }

    @JsonCreator
    public static MapCoder<?, ?> of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
        Preconditions.checkArgument(components.size() == 2, "Expecting 2 components, got " + components.size());
        return MapCoder.of(components.get(0), components.get(1));
    }

    public static <K, V> List<Object> getInstanceComponents(Map<K, V> exampleValue) {
        Iterator<Map.Entry<K, V>> iterator = exampleValue.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            return Arrays.asList(entry.getKey(), entry.getValue());
        }
        return null;
    }

    public Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    MapCoder(Coder<K> keyCoder, Coder<V> valueCoder) {
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
    }

    @Override
    public void encode(Map<K, V> map, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (map == null) {
            throw new CoderException("cannot encode a null Map");
        }
        DataOutputStream dataOutStream = new DataOutputStream(outStream);
        dataOutStream.writeInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keyCoder.encode(entry.getKey(), outStream, context.nested());
            this.valueCoder.encode(entry.getValue(), outStream, context.nested());
        }
        dataOutStream.flush();
    }

    @Override
    public Map<K, V> decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        DataInputStream dataInStream = new DataInputStream(inStream);
        int size = dataInStream.readInt();
        HashMap<K, V> retval = Maps.newHashMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            K key = this.keyCoder.decode(inStream, context.nested());
            V value = this.valueCoder.decode(inStream, context.nested());
            retval.put(key, value);
        }
        return retval;
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return Arrays.asList(this.keyCoder, this.valueCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Ordering of entries in a Map may be non-deterministic.");
    }

    @Override
    public void registerByteSizeObserver(Map<K, V> map, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
        observer.update(4L);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keyCoder.registerByteSizeObserver(entry.getKey(), observer, context.nested());
            this.valueCoder.registerByteSizeObserver(entry.getValue(), observer, context.nested());
        }
    }
}

