/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.VarLongCoder;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class DurationCoder
extends AtomicCoder<ReadableDuration> {
    private static final DurationCoder INSTANCE = new DurationCoder();
    private final VarLongCoder longCoder = VarLongCoder.of();

    @JsonCreator
    public static DurationCoder of() {
        return INSTANCE;
    }

    private DurationCoder() {
    }

    private Long toLong(ReadableDuration value) {
        return value.getMillis();
    }

    private ReadableDuration fromLong(Long decoded) {
        return Duration.millis((long)decoded);
    }

    @Override
    public void encode(ReadableDuration value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null ReadableDuration");
        }
        this.longCoder.encode(this.toLong(value), outStream, context);
    }

    @Override
    public ReadableDuration decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        return this.fromLong(this.longCoder.decode(inStream, context));
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(ReadableDuration value, Coder.Context context) {
        return this.longCoder.isRegisterByteSizeObserverCheap(this.toLong(value), context);
    }

    @Override
    public void registerByteSizeObserver(ReadableDuration value, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
        this.longCoder.registerByteSizeObserver(this.toLong(value), observer, context);
    }
}

