/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.util.Structs;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public abstract class CustomCoder<T>
extends AtomicCoder<T>
implements Serializable {
    @JsonCreator
    public static CustomCoder<?> of(@JsonProperty(value="@type", required=false) String typeId, @JsonProperty(value="encoding_id", required=false) String encodingId, @JsonProperty(value="type") String type, @JsonProperty(value="serialized_coder") String serializedCoder) {
        return (CustomCoder)SerializableUtils.deserializeFromByteArray(StringUtils.jsonStringToByteArray(serializedCoder), type);
    }

    @Override
    public CloudObject asCloudObject() {
        Collection<String> allowedEncodings;
        CloudObject result = CloudObject.forClass(CustomCoder.class);
        Structs.addString((Map<String, Object>)((Object)result), "type", this.getClass().getName());
        Structs.addString((Map<String, Object>)((Object)result), "serialized_coder", StringUtils.byteArrayToJsonString(SerializableUtils.serializeToByteArray(this)));
        String encodingId = this.getEncodingId();
        Preconditions.checkNotNull(encodingId, "Coder.getEncodingId() must not return null.");
        if (!encodingId.isEmpty()) {
            Structs.addString((Map<String, Object>)((Object)result), "encoding_id", encodingId);
        }
        if (!(allowedEncodings = this.getAllowedEncodings()).isEmpty()) {
            Structs.addStringList((Map<String, Object>)((Object)result), "allowed_encodings", Lists.newArrayList(allowedEncodings));
        }
        return result;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "CustomCoder implementations must override verifyDeterministic, or they are presumed nondeterministic.");
    }

    @Override
    public String getEncodingId() {
        if (this.getClass().isAnonymousClass()) {
            throw new UnsupportedOperationException(String.format("Anonymous CustomCoder subclass %s must override getEncodingId(). Otherwise, convert to a named class and getEncodingId() will be automatically generated from the fully qualified class name.", this.getClass()));
        }
        return this.getClass().getCanonicalName();
    }
}

