/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Objects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public interface Coder<T>
extends Serializable {
    public void encode(T var1, OutputStream var2, Context var3) throws CoderException, IOException;

    public T decode(InputStream var1, Context var2) throws CoderException, IOException;

    public List<? extends Coder<?>> getCoderArguments();

    public CloudObject asCloudObject();

    public void verifyDeterministic() throws NonDeterministicException;

    public boolean consistentWithEquals();

    public Object structuralValue(T var1) throws Exception;

    public boolean isRegisterByteSizeObserverCheap(T var1, Context var2);

    public void registerByteSizeObserver(T var1, ElementByteSizeObserver var2, Context var3) throws Exception;

    @Experimental(value=Experimental.Kind.CODER_ENCODING_ID)
    public String getEncodingId();

    @Experimental(value=Experimental.Kind.CODER_ENCODING_ID)
    public Collection<String> getAllowedEncodings();

    public static class NonDeterministicException
    extends Throwable {
        private Coder<?> coder;
        private List<String> reasons;

        public NonDeterministicException(Coder<?> coder, String reason, @Nullable NonDeterministicException e) {
            this(coder, Arrays.asList(reason), e);
        }

        public NonDeterministicException(Coder<?> coder, String reason) {
            this(coder, Arrays.asList(reason), null);
        }

        public NonDeterministicException(Coder<?> coder, List<String> reasons) {
            this(coder, reasons, null);
        }

        public NonDeterministicException(Coder<?> coder, List<String> reasons, @Nullable NonDeterministicException cause) {
            super(cause);
            Preconditions.checkArgument(reasons.size() > 0, "Reasons must not be empty.");
            this.reasons = reasons;
            this.coder = coder;
        }

        public Iterable<String> getReasons() {
            return this.reasons;
        }

        @Override
        public String getMessage() {
            return String.format("%s is not deterministic because:\n  %s", this.coder, Joiner.on("\n  ").join(this.reasons));
        }
    }

    public static class Context {
        public static final Context OUTER = new Context(true);
        public static final Context NESTED = new Context(false);
        public final boolean isWholeStream;

        public Context(boolean isWholeStream) {
            this.isWholeStream = isWholeStream;
        }

        public Context nested() {
            return NESTED;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Context)) {
                return false;
            }
            return Objects.equal(this.isWholeStream, ((Context)obj).isWholeStream);
        }

        public int hashCode() {
            return Objects.hashCode(this.isWholeStream);
        }

        public String toString() {
            return MoreObjects.toStringHelper(Context.class).addValue(this.isWholeStream ? "OUTER" : "NESTED").toString();
        }
    }
}

