/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class BigEndianLongCoder
extends AtomicCoder<Long> {
    private static final BigEndianLongCoder INSTANCE = new BigEndianLongCoder();

    @JsonCreator
    public static BigEndianLongCoder of() {
        return INSTANCE;
    }

    private BigEndianLongCoder() {
    }

    @Override
    public void encode(Long value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Long");
        }
        new DataOutputStream(outStream).writeLong(value);
    }

    @Override
    public Long decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        try {
            return new DataInputStream(inStream).readLong();
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Long value, Coder.Context context) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(Long value, Coder.Context context) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Long");
        }
        return 8L;
    }
}

