/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.auth.Credentials;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Objects;
import java.io.InputStream;
import java.io.Serializable;

public class CredentialOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERVICE_ACCOUNT_JSON_ENV_VARIABLE = "GOOGLE_APPLICATION_CREDENTIALS";
    protected static final Logger LOG = new Logger(CredentialOptions.class);
    private CredentialType credentialType;

    public static CredentialOptions jsonCredentials(InputStream jsonInputStream) {
        return new JsonCredentialsOptions(jsonInputStream);
    }

    public static String getEnvJsonFile() {
        return System.getenv().get(SERVICE_ACCOUNT_JSON_ENV_VARIABLE);
    }

    public static CredentialOptions defaultCredentials() {
        return new CredentialOptions(CredentialType.DefaultCredentials);
    }

    public static CredentialOptions p12Credential(String serviceAccount, String keyFile) {
        return new P12CredentialOptions(serviceAccount, keyFile);
    }

    public static CredentialOptions credential(Credentials credentials) {
        return new UserSuppliedCredentialOptions(credentials);
    }

    public static CredentialOptions nullCredential() {
        LOG.info("Enabling the use of null credentials. This should not be used in production.", new Object[0]);
        return new CredentialOptions(CredentialType.None);
    }

    private CredentialOptions(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    private CredentialOptions() {
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != CredentialOptions.class) {
            return false;
        }
        CredentialOptions other = (CredentialOptions)obj;
        return this.credentialType == other.credentialType;
    }

    public static class JsonCredentialsOptions
    extends CredentialOptions {
        private final InputStream inputStream;
        private Credentials cachedCredentials;

        public JsonCredentialsOptions(InputStream inputStream) {
            super(CredentialType.SuppliedJson);
            this.inputStream = inputStream;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setCachedCredentails(Credentials credentials) {
            this.cachedCredentials = credentials;
        }

        public Credentials getCachedCredentials() {
            return this.cachedCredentials;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != JsonCredentialsOptions.class) {
                return false;
            }
            JsonCredentialsOptions other = (JsonCredentialsOptions)obj;
            return Objects.equal(this.cachedCredentials, other.cachedCredentials);
        }
    }

    public static class UserSuppliedCredentialOptions
    extends CredentialOptions {
        private final Credentials credential;

        public UserSuppliedCredentialOptions(Credentials credential) {
            super(CredentialType.SuppliedCredentials);
            this.credential = credential;
        }

        public Credentials getCredential() {
            return this.credential;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != UserSuppliedCredentialOptions.class) {
                return false;
            }
            UserSuppliedCredentialOptions other = (UserSuppliedCredentialOptions)obj;
            return Objects.equal(this.credential, other.credential);
        }
    }

    public static class P12CredentialOptions
    extends CredentialOptions {
        private final String serviceAccount;
        private final String keyFile;

        private P12CredentialOptions(String serviceAccount, String keyFile) {
            super(CredentialType.P12);
            this.serviceAccount = serviceAccount;
            this.keyFile = keyFile;
        }

        public String getServiceAccount() {
            return this.serviceAccount;
        }

        public String getKeyFile() {
            return this.keyFile;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != P12CredentialOptions.class) {
                return false;
            }
            P12CredentialOptions other = (P12CredentialOptions)obj;
            return Objects.equal(this.keyFile, other.keyFile) && Objects.equal(this.serviceAccount, other.serviceAccount);
        }
    }

    public static enum CredentialType {
        DefaultCredentials,
        P12,
        SuppliedCredentials,
        SuppliedJson,
        None;

    }
}

