/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.util;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class ZeroCopyByteStringUtil {
    public static ByteString wrap(byte[] array) {
        return UnsafeByteOperations.unsafeWrap((byte[])array);
    }

    public static byte[] get(ByteString byteString) {
        try {
            ZeroCopyByteOutput byteOutput = new ZeroCopyByteOutput();
            UnsafeByteOperations.unsafeWriteTo((ByteString)byteString, (ByteOutput)byteOutput);
            return byteOutput.bytes;
        }
        catch (IOException e) {
            return byteString.toByteArray();
        }
    }

    private static final class ZeroCopyByteOutput
    extends ByteOutput {
        private byte[] bytes;

        private ZeroCopyByteOutput() {
        }

        public void writeLazy(byte[] value, int offset, int length) {
            if (offset != 0 || length != value.length) {
                throw new UnsupportedOperationException();
            }
            this.bytes = value;
        }

        public void write(byte value) {
            throw new UnsupportedOperationException();
        }

        public void write(byte[] value, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public void write(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }

        public void writeLazy(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }
    }
}

