/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.util;

import com.google.cloud.bigtable.util.ZeroCopyByteStringUtil;
import com.google.protobuf.ByteString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ByteStringer {
    private static final Log LOG = LogFactory.getLog(ByteStringer.class);
    private static boolean USE_ZEROCOPYBYTESTRING = true;

    private ByteStringer() {
    }

    public static ByteString wrap(byte[] array) {
        return USE_ZEROCOPYBYTESTRING ? ZeroCopyByteStringUtil.wrap(array) : ByteString.copyFrom((byte[])array);
    }

    public static ByteString wrap(byte[] array, int offset, int length) {
        if (USE_ZEROCOPYBYTESTRING && offset == 0 && length == array.length) {
            return ZeroCopyByteStringUtil.wrap(array);
        }
        return ByteString.copyFrom((byte[])array, (int)offset, (int)length);
    }

    public static byte[] extract(ByteString buf) {
        return USE_ZEROCOPYBYTESTRING ? ZeroCopyByteStringUtil.get(buf) : buf.toByteArray();
    }

    static {
        try {
            ZeroCopyByteStringUtil.wrap(new byte[0]);
        }
        catch (IllegalAccessError iae) {
            USE_ZEROCOPYBYTESTRING = false;
            LOG.debug((Object)("Failed to classload BigtableZeroCopyByteString: " + iae.toString()));
        }
    }
}

