/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;

public class StreamObserverAdapter<T>
extends ClientCall.Listener<T> {
    private final ClientCall<?, T> call;
    private final StreamObserver<T> observer;
    private boolean statusRecieved = false;

    public StreamObserverAdapter(ClientCall<?, T> call, StreamObserver<T> observer) {
        this.call = call;
        this.observer = observer;
    }

    public void onMessage(T message) {
        this.call.request(1);
        this.observer.onNext(message);
    }

    public void onClose(Status status, Metadata trailers) {
        this.statusRecieved = true;
        if (status.isOk()) {
            this.observer.onCompleted();
        } else {
            this.observer.onError((Throwable)status.asRuntimeException());
        }
    }

    public boolean hasStatusBeenRecieved() {
        return this.statusRecieved;
    }
}

