/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.util.ByteStringer;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RowMerger
implements StreamObserver<ReadRowsResponse> {
    private final StreamObserver<FlatRow> observer;
    private RowMergerState state = RowMergerState.NewRow;
    private ByteString lastCompletedRowKey = null;
    private RowInProgress rowInProgress;
    private boolean complete;

    public static List<FlatRow> toRows(Iterable<ReadRowsResponse> responses) {
        final ArrayList<FlatRow> result = new ArrayList<FlatRow>();
        RowMerger rowMerger = new RowMerger(new StreamObserver<FlatRow>(){

            public void onNext(FlatRow value) {
                result.add(value);
            }

            public void onError(Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new IllegalStateException(t);
            }

            public void onCompleted() {
            }
        });
        for (ReadRowsResponse response : responses) {
            rowMerger.onNext(response);
        }
        rowMerger.onCompleted();
        return result;
    }

    public RowMerger(StreamObserver<FlatRow> observer) {
        this.observer = observer;
    }

    public final void onNext(ReadRowsResponse readRowsResponse) {
        if (this.complete) {
            this.onError(new IllegalStateException("Adding partialRow after completion"));
            return;
        }
        for (int i = 0; i < readRowsResponse.getChunksCount(); ++i) {
            try {
                ReadRowsResponse.CellChunk chunk = readRowsResponse.getChunks(i);
                this.state.validateChunk(this.rowInProgress, this.lastCompletedRowKey, chunk);
                if (chunk.getResetRow()) {
                    this.rowInProgress = null;
                    this.state = RowMergerState.NewRow;
                    continue;
                }
                if (this.state == RowMergerState.NewRow) {
                    this.rowInProgress = new RowInProgress();
                    this.rowInProgress.updateCurrentKey(chunk);
                } else if (this.state == RowMergerState.RowInProgress) {
                    this.rowInProgress.updateCurrentKey(chunk);
                }
                if (chunk.getValueSize() > 0) {
                    this.rowInProgress.addPartialCellChunk(chunk);
                    this.state = RowMergerState.CellInProgress;
                } else if (this.rowInProgress.hasChunkInProgess()) {
                    this.rowInProgress.addPartialCellChunk(chunk);
                    this.rowInProgress.completeMultiChunkCell();
                    this.state = RowMergerState.RowInProgress;
                } else {
                    this.rowInProgress.addFullChunk(chunk);
                    this.state = RowMergerState.RowInProgress;
                }
                if (!chunk.getCommitRow()) continue;
                this.observer.onNext((Object)this.rowInProgress.buildRow());
                this.lastCompletedRowKey = this.rowInProgress.getRowKey();
                this.rowInProgress = null;
                this.state = RowMergerState.NewRow;
                continue;
            }
            catch (Throwable e) {
                this.onError(e);
                return;
            }
        }
    }

    public void onError(Throwable e) {
        this.observer.onError(e);
        this.complete = true;
    }

    public void onCompleted() {
        this.state.handleOnComplete(this.observer);
    }

    public ByteString getLastCompletedRowKey() {
        return this.lastCompletedRowKey;
    }

    private static final class RowInProgress {
        private ByteString rowKey;
        private CellIdentifier currentId;
        private ByteArrayOutputStream outputStream;
        private final Map<String, List<FlatRow.Cell>> cells = new TreeMap<String, List<FlatRow.Cell>>();
        private List<FlatRow.Cell> currentFamilyRowCells = null;
        private String currentFamily;
        private FlatRow.Cell previousNoLabelCell;

        private RowInProgress() {
        }

        private final void addFullChunk(ReadRowsResponse.CellChunk chunk) {
            Preconditions.checkState((!this.hasChunkInProgess() ? 1 : 0) != 0);
            this.addCell(chunk.getValue());
        }

        private final void completeMultiChunkCell() {
            Preconditions.checkArgument((boolean)this.hasChunkInProgess());
            this.addCell(ByteStringer.wrap(this.outputStream.toByteArray()));
            this.outputStream = null;
        }

        private void addCell(ByteString value) {
            if (!Objects.equal((Object)this.currentFamily, (Object)this.currentId.family)) {
                this.currentFamilyRowCells = new ArrayList<FlatRow.Cell>();
                this.currentFamily = this.currentId.family;
                this.cells.put(this.currentId.family, this.currentFamilyRowCells);
                this.previousNoLabelCell = null;
            }
            FlatRow.Cell cell = new FlatRow.Cell(this.currentId.family, this.currentId.qualifier, this.currentId.timestampMicros, value, this.currentId.labels);
            if (!this.currentId.labels.isEmpty()) {
                this.currentFamilyRowCells.add(cell);
            } else if (!this.isSameTimestampAndQualifier()) {
                this.currentFamilyRowCells.add(cell);
                this.previousNoLabelCell = cell;
            }
        }

        private boolean isSameTimestampAndQualifier() {
            return this.previousNoLabelCell != null && this.currentId.timestampMicros == this.previousNoLabelCell.getTimestamp() && Objects.equal((Object)this.previousNoLabelCell.getQualifier(), (Object)this.currentId.qualifier);
        }

        private final void updateCurrentKey(ReadRowsResponse.CellChunk chunk) {
            ByteString newRowKey = chunk.getRowKey();
            if (this.rowKey == null || !newRowKey.isEmpty() && !newRowKey.equals((Object)this.rowKey)) {
                this.rowKey = newRowKey;
                this.currentId = new CellIdentifier(chunk);
                this.currentFamily = null;
                this.cells.clear();
                this.currentFamilyRowCells = null;
            } else if (chunk.hasFamilyName()) {
                this.currentId.updateForFamily(chunk);
            } else if (chunk.hasQualifier()) {
                this.currentId.updateForQualifier(chunk);
            } else {
                this.currentId.updateForTimestamp(chunk);
            }
        }

        private boolean hasChunkInProgess() {
            return this.outputStream != null;
        }

        private void addPartialCellChunk(ReadRowsResponse.CellChunk chunk) throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new ByteArrayOutputStream(chunk.getValueSize());
            }
            chunk.getValue().writeTo((OutputStream)this.outputStream);
        }

        private ByteString getRowKey() {
            return this.rowKey;
        }

        private boolean hasRowKey() {
            return this.rowKey != null;
        }

        private FlatRow buildRow() {
            return new FlatRow(this.rowKey, this.flattenCells());
        }

        private ImmutableList<FlatRow.Cell> flattenCells() {
            ImmutableList.Builder combined = ImmutableList.builder();
            for (List<FlatRow.Cell> familyCellList : this.cells.values()) {
                combined.addAll(familyCellList);
            }
            return combined.build();
        }
    }

    private static class CellIdentifier {
        String family;
        ByteString qualifier;
        long timestampMicros;
        List<String> labels;

        private CellIdentifier(ReadRowsResponse.CellChunk chunk) {
            this.updateForFamily(chunk);
        }

        private void updateForFamily(ReadRowsResponse.CellChunk chunk) {
            String chunkFamily = chunk.getFamilyName().getValue();
            if (!chunkFamily.equals(this.family)) {
                this.family = chunkFamily;
            }
            this.updateForQualifier(chunk);
        }

        private void updateForQualifier(ReadRowsResponse.CellChunk chunk) {
            this.qualifier = chunk.getQualifier().getValue();
            this.updateForTimestamp(chunk);
        }

        private void updateForTimestamp(ReadRowsResponse.CellChunk chunk) {
            this.timestampMicros = chunk.getTimestampMicros();
            this.labels = chunk.getLabelsList();
        }
    }

    private static enum RowMergerState {
        NewRow{

            @Override
            void validateChunk(RowInProgress rowInProgess, ByteString previousKey, ReadRowsResponse.CellChunk newChunk) {
                Preconditions.checkArgument((rowInProgess == null || !rowInProgess.hasRowKey() ? 1 : 0) != 0, (String)"A new row cannot have existing state: %s", (Object[])new Object[]{newChunk});
                Preconditions.checkArgument((newChunk.getRowStatusCase() != ReadRowsResponse.CellChunk.RowStatusCase.RESET_ROW ? 1 : 0) != 0, (String)"A new row cannot be reset: %s", (Object[])new Object[]{newChunk});
                Preconditions.checkArgument((boolean)newChunk.hasFamilyName(), (String)"A family must be set: %s", (Object[])new Object[]{newChunk});
                ByteString rowKey = newChunk.getRowKey();
                Preconditions.checkArgument((!rowKey.isEmpty() ? 1 : 0) != 0, (String)"A row key must be set: %s", (Object[])new Object[]{newChunk});
                Preconditions.checkState((previousKey == null || !rowKey.equals((Object)previousKey) ? 1 : 0) != 0, (String)"A commit happened but the same key followed: %s", (Object[])new Object[]{newChunk});
                Preconditions.checkArgument((boolean)newChunk.hasQualifier(), (String)"A column qualifier must be set: %s", (Object[])new Object[]{newChunk});
                if (newChunk.getValueSize() > 0) {
                    Preconditions.checkArgument((!newChunk.getCommitRow() ? 1 : 0) != 0, (String)"A row cannot be have a value size and be a commit row: %s", (Object[])new Object[]{newChunk});
                }
            }

            @Override
            void handleOnComplete(StreamObserver<FlatRow> observer) {
                observer.onCompleted();
            }
        }
        ,
        RowInProgress{

            @Override
            void validateChunk(RowInProgress rowInProgess, ByteString previousKey, ReadRowsResponse.CellChunk newChunk) {
                if (newChunk.hasFamilyName()) {
                    Preconditions.checkArgument((boolean)newChunk.hasQualifier(), (String)"A qualifier must be specified: %s", (Object[])new Object[]{newChunk});
                }
                ByteString newRowKey = newChunk.getRowKey();
                if (newChunk.getResetRow()) {
                    Preconditions.checkState((newRowKey.isEmpty() && !newChunk.hasFamilyName() && !newChunk.hasQualifier() && newChunk.getValue().isEmpty() && newChunk.getTimestampMicros() == 0L ? 1 : 0) != 0, (Object)"A reset should have no data");
                } else {
                    Preconditions.checkState((newRowKey.isEmpty() || newRowKey.equals((Object)rowInProgess.getRowKey()) ? 1 : 0) != 0, (String)"A commit is required between row keys: %s", (Object[])new Object[]{newChunk});
                    Preconditions.checkArgument((newChunk.getValueSize() == 0 || !newChunk.getCommitRow() ? 1 : 0) != 0, (String)"A row cannot be have a value size and be a commit row: %s", (Object[])new Object[]{newChunk});
                }
            }

            @Override
            void handleOnComplete(StreamObserver<FlatRow> observer) {
                observer.onError((Throwable)new IllegalStateException("Got a partial row, but the stream ended"));
            }
        }
        ,
        CellInProgress{

            @Override
            void validateChunk(RowInProgress rowInProgess, ByteString previousKey, ReadRowsResponse.CellChunk newChunk) {
                if (newChunk.getResetRow()) {
                    Preconditions.checkState((newChunk.getRowKey().isEmpty() && !newChunk.hasFamilyName() && !newChunk.hasQualifier() && newChunk.getValue().isEmpty() && newChunk.getTimestampMicros() == 0L ? 1 : 0) != 0, (Object)"A reset should have no data");
                } else {
                    Preconditions.checkArgument((newChunk.getValueSize() == 0 || !newChunk.getCommitRow() ? 1 : 0) != 0, (String)"A row cannot be have a value size and be a commit row: %s", (Object[])new Object[]{newChunk});
                }
            }

            @Override
            void handleOnComplete(StreamObserver<FlatRow> observer) {
                observer.onError((Throwable)new IllegalStateException("Got a partial row, but the stream ended"));
            }
        };


        abstract void validateChunk(RowInProgress var1, ByteString var2, ReadRowsResponse.CellChunk var3) throws Exception;

        abstract void handleOnComplete(StreamObserver<FlatRow> var1);
    }
}

