/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.protobuf.ByteString;
import java.util.List;

public class FlatRowConverter {
    public static Row convert(FlatRow row) {
        if (row == null) {
            return null;
        }
        Row.Builder rowBuilder = Row.newBuilder().setKey(row.getRowKey());
        String prevFamily = null;
        Family.Builder familyBuilder = null;
        ByteString previousColumn = null;
        Column.Builder columnBuilder = null;
        for (FlatRow.Cell cell : row.getCells()) {
            ByteString currentQualifier;
            String currentFamily = cell.getFamily();
            if (!currentFamily.equals(prevFamily)) {
                if (familyBuilder != null) {
                    if (columnBuilder != null) {
                        familyBuilder.addColumns(columnBuilder.build());
                        columnBuilder = null;
                        previousColumn = null;
                    }
                    rowBuilder.addFamilies(familyBuilder.build());
                }
                familyBuilder = Family.newBuilder().setName(currentFamily);
                prevFamily = currentFamily;
            }
            if (!(currentQualifier = cell.getQualifier()).equals(previousColumn)) {
                if (columnBuilder != null) {
                    familyBuilder.addColumns(columnBuilder.build());
                }
                columnBuilder = Column.newBuilder().setQualifier(currentQualifier);
                previousColumn = currentQualifier;
            }
            columnBuilder.addCells(FlatRowConverter.toCell(cell));
        }
        if (familyBuilder != null) {
            if (columnBuilder != null) {
                familyBuilder.addColumns(columnBuilder.build());
            }
            rowBuilder.addFamilies(familyBuilder.build());
        }
        return rowBuilder.build();
    }

    private static Cell toCell(FlatRow.Cell cell) {
        return Cell.newBuilder().setTimestampMicros(cell.getTimestamp()).addAllLabels(cell.getLabels()).setValue(cell.getValue()).build();
    }

    public static FlatRow convert(Row row) {
        FlatRow.Builder builder = FlatRow.newBuilder().withRowKey(row.getKey());
        for (Family family : row.getFamiliesList()) {
            String familyName = family.getName();
            for (Column column : family.getColumnsList()) {
                ByteString qualifier = column.getQualifier();
                for (Cell cell : column.getCellsList()) {
                    builder.addCell(familyName, qualifier, cell.getTimestampMicros(), cell.getValue(), (List<String>)cell.getLabelsList());
                }
            }
        }
        return builder.build();
    }
}

