/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.api.client.util.Clock;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.bigtable.config.Logger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public class RefreshingOAuth2CredentialsInterceptor
implements ClientInterceptor {
    private static final Logger LOG = new Logger(RefreshingOAuth2CredentialsInterceptor.class);
    private static final Metadata.Key<String> AUTHORIZATION_HEADER_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static Clock clock = Clock.SYSTEM;
    private static final HeaderCacheElement EMPTY_HEADER = new HeaderCacheElement(null, 0L);
    private final ExecutorService executor;
    @VisibleForTesting
    RateLimiter rateLimiter;
    private final OAuth2Credentials credentials;
    @VisibleForTesting
    final Object lock = new Object();
    @VisibleForTesting
    @GuardedBy(value="lock")
    volatile HeaderCacheElement headerCache = EMPTY_HEADER;
    @VisibleForTesting
    @GuardedBy(value="lock")
    boolean isRefreshing = false;
    @VisibleForTesting
    @GuardedBy(value="lock")
    Future<HeaderCacheElement> futureToken = null;

    public RefreshingOAuth2CredentialsInterceptor(ExecutorService scheduler, OAuth2Credentials credentials) {
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)scheduler);
        this.credentials = (OAuth2Credentials)Preconditions.checkNotNull((Object)credentials);
        this.rateLimiter = RateLimiter.create((double)1.0);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                HeaderCacheElement headerCache = RefreshingOAuth2CredentialsInterceptor.this.getHeaderSafe();
                if (!headerCache.status.isOk()) {
                    responseListener.onClose(headerCache.status, new Metadata());
                    return;
                }
                headers.put(AUTHORIZATION_HEADER_KEY, (Object)headerCache.header);
                this.delegate().start(new UnAuthResponseListener(responseListener, headerCache), headers);
            }
        };
    }

    @VisibleForTesting
    HeaderCacheElement getHeaderSafe() {
        try {
            return this.getHeader();
        }
        catch (Exception e) {
            return new HeaderCacheElement(Status.UNAUTHENTICATED.withDescription("Unexpected failure get auth token").withCause((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    HeaderCacheElement getHeader() throws ExecutionException, InterruptedException, TimeoutException {
        Future<HeaderCacheElement> deferredResult;
        HeaderCacheElement headerCacheUnsync = this.headerCache;
        if (headerCacheUnsync.getCacheState() == CacheState.Good) {
            return headerCacheUnsync;
        }
        Object object = this.lock;
        synchronized (object) {
            CacheState state = this.headerCache.getCacheState();
            switch (state) {
                case Good: {
                    return this.headerCache;
                }
                case Stale: {
                    this.asyncRefresh();
                    return this.headerCache;
                }
                case Expired: 
                case Exception: {
                    deferredResult = this.asyncRefresh();
                    break;
                }
                default: {
                    return new HeaderCacheElement(Status.UNAUTHENTICATED.withCause((Throwable)new IllegalStateException("Could not process state: " + (Object)((Object)state))));
                }
            }
        }
        return deferredResult.get(250L, TimeUnit.MILLISECONDS);
    }

    HeaderCacheElement syncRefresh() {
        try {
            return this.asyncRefresh().get(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return new HeaderCacheElement(Status.UNAUTHENTICATED.withCause((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<HeaderCacheElement> asyncRefresh() {
        LOG.trace("asyncRefresh", new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            if (this.isRefreshing) {
                LOG.trace("asyncRefresh is already in progress", new Object[0]);
                return this.futureToken;
            }
            this.isRefreshing = true;
            LOG.trace("asyncRefresh taking ownership", new Object[0]);
            try {
                this.futureToken = this.executor.submit(new Callable<HeaderCacheElement>(){

                    @Override
                    public HeaderCacheElement call() throws Exception {
                        HeaderCacheElement newToken = RefreshingOAuth2CredentialsInterceptor.this.refreshCredentials();
                        return RefreshingOAuth2CredentialsInterceptor.this.updateToken(newToken);
                    }
                });
            }
            catch (RuntimeException e) {
                this.isRefreshing = false;
                throw e;
            }
            return this.futureToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeaderCacheElement updateToken(HeaderCacheElement newToken) {
        Object object = this.lock;
        synchronized (object) {
            boolean oldTokenOk;
            CacheState newState = newToken.getCacheState();
            boolean newTokenOk = newState == CacheState.Good || newState == CacheState.Stale;
            CacheState oldCacheState = this.headerCache.getCacheState();
            boolean bl = oldTokenOk = oldCacheState == CacheState.Good || oldCacheState == CacheState.Stale;
            if (newTokenOk || !oldTokenOk) {
                this.headerCache = newToken;
            } else {
                LOG.warn("Failed to refresh the access token. Falling back to existing token. New token state: {}, status: {}", new Object[]{newState, newToken.status});
            }
            this.futureToken = null;
            this.isRefreshing = false;
            return this.headerCache;
        }
    }

    private HeaderCacheElement refreshCredentials() {
        if (!this.rateLimiter.tryAcquire()) {
            LOG.trace("Rate limited", new Object[0]);
            return new HeaderCacheElement(Status.UNAUTHENTICATED.withDescription("Authentication rate limit has been exceeded, failing fast"));
        }
        try {
            LOG.info("Refreshing the OAuth token", new Object[0]);
            AccessToken newToken = this.credentials.refreshAccessToken();
            return new HeaderCacheElement(newToken);
        }
        catch (Exception e) {
            LOG.warn("Got an unexpected exception while trying to refresh google credentials.", e, new Object[0]);
            return new HeaderCacheElement(Status.UNAUTHENTICATED.withDescription("Unexpected error trying to authenticate").withCause((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeUnauthToken(HeaderCacheElement oldToken) {
        Object object = this.lock;
        synchronized (object) {
            if (this.headerCache == oldToken) {
                LOG.warn("Got unauthenticated response from server, revoking the current token", new Object[0]);
                this.headerCache = EMPTY_HEADER;
            } else {
                LOG.info("Skipping revoke, since the revoked token has already changed", new Object[0]);
            }
        }
    }

    class UnAuthResponseListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        private final HeaderCacheElement origToken;

        UnAuthResponseListener(ClientCall.Listener<RespT> delegate, HeaderCacheElement origToken) {
            super(delegate);
            this.origToken = origToken;
        }

        public void onClose(Status status, Metadata trailers) {
            if (status == Status.UNAUTHENTICATED) {
                RefreshingOAuth2CredentialsInterceptor.this.revokeUnauthToken(this.origToken);
            }
            super.onClose(status, trailers);
        }
    }

    @VisibleForTesting
    static class HeaderCacheElement {
        static final long TOKEN_STALENESS_MS = TimeUnit.MINUTES.toMillis(6L);
        static final long TOKEN_EXPIRES_MS = TimeUnit.MINUTES.toMillis(5L);
        final Status status;
        final String header;
        final long actualExpirationTimeMs;

        HeaderCacheElement(AccessToken token) {
            this.status = Status.OK;
            this.actualExpirationTimeMs = token.getExpirationTime() == null ? Long.MAX_VALUE : token.getExpirationTime().getTime();
            this.header = "Bearer " + token.getTokenValue();
        }

        HeaderCacheElement(String header, long actualExpirationTimeMs) {
            this.status = Status.OK;
            this.header = header;
            this.actualExpirationTimeMs = actualExpirationTimeMs;
        }

        HeaderCacheElement(Status errorStatus) {
            Preconditions.checkArgument((!errorStatus.isOk() ? 1 : 0) != 0, (Object)"Error status can't be OK");
            this.status = errorStatus;
            this.header = null;
            this.actualExpirationTimeMs = 0L;
        }

        CacheState getCacheState() {
            long now = clock.currentTimeMillis();
            if (!this.status.isOk()) {
                return CacheState.Exception;
            }
            if (this.actualExpirationTimeMs - TOKEN_EXPIRES_MS <= now) {
                return CacheState.Expired;
            }
            if (this.actualExpirationTimeMs - TOKEN_STALENESS_MS <= now) {
                return CacheState.Stale;
            }
            return CacheState.Good;
        }
    }

    @VisibleForTesting
    static enum CacheState {
        Good,
        Stale,
        Expired,
        Exception;

    }
}

