/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.StatusException;

public class GoogleCloudResourcePrefixInterceptor
implements ClientInterceptor {
    public static final Metadata.Key<String> GRPC_RESOURCE_PREFIX_KEY = Metadata.Key.of((String)"google-cloud-resource-prefix", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final String defaultValue;

    public GoogleCloudResourcePrefixInterceptor(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws StatusException {
                GoogleCloudResourcePrefixInterceptor.this.updateHeaders(headers);
                this.delegate().start(responseListener, headers);
            }
        };
    }

    @VisibleForTesting
    public void updateHeaders(Metadata headers) {
        if (!headers.containsKey(GRPC_RESOURCE_PREFIX_KEY)) {
            headers.put(GRPC_RESOURCE_PREFIX_KEY, (Object)this.defaultValue);
        }
    }
}

